/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.sql;

import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.InsertFieldCommand;
import jimm.datavision.gui.cmd.NewSubreportCommand;
import jimm.datavision.gui.sql.VisTableWin;
import jimm.datavision.source.Column;
import jimm.datavision.source.Join;
import jimm.datavision.source.Query;
import jimm.util.I18N;

public class SubreportWin
extends VisTableWin {
    JLabel thisReportLabel;
    JLabel subreportLabel;

    public SubreportWin(Designer designer, Report report) {
        super(designer, report, new Query(report));
    }

    protected void fillJoinsPanel() {
        this.delCheckBoxPanel.add(new JLabel(" "));
        this.thisReportLabel = new JLabel(I18N.get("SubreportWin.this_report"));
        this.fromPanel.add(this.thisReportLabel);
        this.thisReportLabel.setVisible(false);
        this.relationPanel.add(new JLabel(" "));
        this.subreportLabel = new JLabel(I18N.get("SubreportWin.subreport"));
        this.toPanel.add(this.subreportLabel);
        this.subreportLabel.setVisible(false);
        super.fillJoinsPanel();
    }

    protected void addNewJoin() {
        super.addNewJoin();
        this.thisReportLabel.setVisible(true);
        this.subreportLabel.setVisible(true);
    }

    protected void deleteSelectedJoins() {
        super.deleteSelectedJoins();
        this.thisReportLabel.setVisible(!this.joinFieldsList.isEmpty());
        this.subreportLabel.setVisible(!this.joinFieldsList.isEmpty());
    }

    protected void doSave() {
        JFileChooser jFileChooser = Designer.getChooser();
        int n = jFileChooser.showOpenDialog(this.designer.getFrame());
        if (n == 0) {
            ArrayList<Join> arrayList = new ArrayList<Join>();
            Object object = this.joinFieldsList.iterator();
            while (object.hasNext()) {
                VisTableWin.JoinFields joinFields = (VisTableWin.JoinFields)object.next();
                Column column = this.columnFromDropdown(joinFields.from);
                String string = (String)joinFields.relation.getSelectedItem();
                Column column2 = this.columnFromDropdown(joinFields.to);
                arrayList.add(new Join(column, string, column2));
            }
            try {
                object = new NewSubreportCommand(this.designer, this.report, jFileChooser.getSelectedFile(), arrayList);
                ((InsertFieldCommand)object).perform();
                this.commands.add((Command)object);
            }
            catch (Exception exception) {
                ErrorHandler.error(exception);
            }
        }
    }
}

