/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jimm.datavision.gui.EditFieldLayout;
import jimm.datavision.gui.FocusSetter;
import jimm.util.I18N;

public class DbPasswordDialog
extends JDialog
implements ActionListener {
    protected static final int FIELD_COLUMNS = 20;
    protected String username;
    protected String password;
    protected JTextField usernameField;
    protected JPasswordField passwordField;

    public DbPasswordDialog(Frame frame, String string, String string2) {
        super(frame, I18N.get("DbPasswordDialog.title"), true);
        this.username = string2 == null ? "" : string2;
        this.buildWindow(string);
        this.pack();
        this.setVisible(true);
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected void buildWindow(String string) {
        this.getContentPane().setLayout(new BorderLayout());
        EditFieldLayout editFieldLayout = new EditFieldLayout();
        editFieldLayout.addLabel(I18N.get("DbPasswordDialog.database"), string);
        editFieldLayout.setBorder(20);
        this.usernameField = editFieldLayout.addTextField(I18N.get("DbPasswordDialog.user_name"), this.username, 20);
        this.passwordField = editFieldLayout.addPasswordField(I18N.get("DbPasswordDialog.password"), 20);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("GUI.ok"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(I18N.get("GUI.cancel"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        this.getContentPane().add((Component)editFieldLayout.getPanel(), "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DbPasswordDialog.this.dispose();
            }
        });
        new FocusSetter(this.passwordField);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("GUI.ok").equals(string)) {
            this.username = this.usernameField.getText();
            this.password = new String(this.passwordField.getPassword());
            this.dispose();
        } else if (I18N.get("GUI.cancel").equals(string)) {
            this.dispose();
        }
    }
}

