/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.sql;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditFieldLayout;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.FocusSetter;
import jimm.datavision.gui.cmd.DbConnCommand;
import jimm.datavision.gui.sql.DbConnReader;
import jimm.datavision.source.sql.Database;
import jimm.util.I18N;
import jimm.util.StringUtils;

public class DbConnWin
extends EditWin
implements ActionListener {
    protected static final int TEXT_FIELD_COLS = 32;
    protected Report report;
    protected JTextField driverClassNameField;
    protected JTextField connInfoField;
    protected JTextField dbNameField;
    protected JTextField userNameField;
    protected JPasswordField passwordField;

    public DbConnWin(Designer designer, Report report, boolean bl) {
        super(designer, I18N.get("DbConnWin.title"), "DbConnCommand.name", bl);
        this.report = report;
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        JPanel jPanel = this.buildEditor();
        JPanel jPanel2 = this.closeButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        new FocusSetter(this.driverClassNameField);
    }

    protected JPanel buildEditor() {
        String string;
        Database database = (Database)this.report.getDataSource();
        EditFieldLayout editFieldLayout = new EditFieldLayout();
        editFieldLayout.setBorder(20);
        this.driverClassNameField = editFieldLayout.addTextField(I18N.get("DbConnWin.driver_class_name"), database == null ? "" : database.getDriverClassName(), 32);
        this.connInfoField = editFieldLayout.addTextField(I18N.get("DbConnWin.connection_info"), database == null ? "" : database.getConnectionInfo(), 32);
        this.dbNameField = editFieldLayout.addTextField(I18N.get("DbConnWin.database_name"), database == null ? "" : database.getName(), 32);
        this.userNameField = editFieldLayout.addTextField(I18N.get("DbConnWin.user_name"), database == null ? "" : database.getUserName(), 32);
        String string2 = string = database == null ? "" : database.getPassword();
        if (string == null) {
            string = "";
        }
        this.passwordField = editFieldLayout.addPasswordField(I18N.get("DbConnWin.password"), string, 32);
        JButton jButton = new JButton(I18N.get("DbConnWin.copy_settings"));
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        editFieldLayout.add(null, jPanel);
        return editFieldLayout.getPanel();
    }

    protected void fillEditFields() {
        Database database = (Database)this.report.getDataSource();
        if (database == null) {
            this.driverClassNameField.setText("");
            this.connInfoField.setText("");
            this.dbNameField.setText("");
            this.userNameField.setText("");
        } else {
            this.driverClassNameField.setText(database.getDriverClassName());
            this.connInfoField.setText(database.getConnectionInfo());
            this.dbNameField.setText(database.getName());
            this.userNameField.setText(database.getUserName());
        }
        this.passwordField.setText("");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("DbConnWin.copy_settings").equals(string)) {
            JFileChooser jFileChooser = Designer.getChooser();
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                DbConnReader dbConnReader = new DbConnReader();
                try {
                    dbConnReader.read(jFileChooser.getSelectedFile());
                    this.driverClassNameField.setText(dbConnReader.getDriverClassName());
                    this.connInfoField.setText(dbConnReader.getConnectionInfo());
                    this.dbNameField.setText(dbConnReader.getDbName());
                    this.userNameField.setText(dbConnReader.getUserName());
                }
                catch (Exception exception) {
                    ErrorHandler.error(I18N.get("DbConnWin.copy_error"), exception);
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void doSave() {
        DbConnCommand dbConnCommand = new DbConnCommand(this.report, StringUtils.nullOrTrimmed(this.driverClassNameField.getText()), StringUtils.nullOrTrimmed(this.connInfoField.getText()), StringUtils.nullOrTrimmed(this.dbNameField.getText()), StringUtils.nullOrTrimmed(this.userNameField.getText()), StringUtils.nullOrTrimmed(new String(this.passwordField.getPassword())));
        dbConnCommand.perform();
        this.commands.add(dbConnCommand);
    }

    protected void doRevert() {
        this.fillEditFields();
    }
}

