/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.parameter;

import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jimm.datavision.Parameter;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.ParamEditCommand;
import jimm.util.I18N;

public class ParamEditWin
extends EditWin {
    protected static final int HORIZ_GAP = 20;
    protected static final int VERT_GAP = 20;
    protected static final int TEXT_FIELD_COLS = 24;
    protected static final String CARD_NAME_SINGLE = "single";
    protected static final String CARD_NAME_SINGLE_BOOL = "single-bool";
    protected static final String CARD_NAME_RANGE = "range";
    protected static final String CARD_NAME_LIST = "list";
    protected static final String CARD_NAME_DATE = "date";
    protected Parameter param;
    protected JTextField nameField;
    protected JTextField questionField;
    protected JRadioButton boolRButton;
    protected JRadioButton stringRButton;
    protected JRadioButton numericRButton;
    protected JRadioButton dateRButton;
    protected JRadioButton singleRButton;
    protected JRadioButton rangeRButton;
    protected JRadioButton listSingleRButton;
    protected JRadioButton listMultipleRButton;
    protected JPanel cardPanel;
    protected JTextField singleField;
    protected JCalendar singleDate;
    protected JTextField rangeFromField;
    protected JTextField rangeToField;
    protected JCalendar rangeFromDate;
    protected JCalendar rangeToDate;
    protected JRadioButton boolYesRButton;
    protected JRadioButton boolNoRButton;
    protected JList list;
    protected JTextField listAddField;

    public ParamEditWin(Designer designer, Parameter parameter) {
        super(designer, I18N.get("ParamEditWin.title"), "ParamEditCommand.name");
        this.param = parameter;
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        this.getContentPane().add((Component)this.buildPromptPanel(), "North");
        this.getContentPane().add((Component)this.buildCenterPanel(), "Center");
        this.getContentPane().add((Component)this.closeButtonPanel(), "South");
        this.fillEditWidgets();
    }

    protected JPanel buildPromptPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        JLabel jLabel = new JLabel(I18N.get("ParamEditWin.name"));
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(4);
        jLabel = new JLabel(I18N.get("ParamEditWin.question"));
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(4);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        this.nameField = new JTextField(24);
        jPanel3.add(this.nameField);
        this.questionField = new JTextField(24);
        jPanel3.add(this.questionField);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel);
        return jPanel4;
    }

    protected JPanel buildCenterPanel() {
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        box.add(this.buildRadioButtonsPanel());
        box.add(this.buildCardPanel());
        jPanel.add(box);
        return jPanel;
    }

    protected JPanel buildRadioButtonsPanel() {
        JPanel jPanel = new JPanel();
        Box box = Box.createVerticalBox();
        ButtonGroup buttonGroup = new ButtonGroup();
        box.add(new JLabel("Type"));
        this.boolRButton = this.addRadioButton(I18N.get("ParamEditWin.bool"), box, buttonGroup);
        this.stringRButton = this.addRadioButton(I18N.get("ParamEditWin.text"), box, buttonGroup);
        this.numericRButton = this.addRadioButton(I18N.get("ParamEditWin.number"), box, buttonGroup);
        this.dateRButton = this.addRadioButton(I18N.get("ParamEditWin.date"), box, buttonGroup);
        jPanel.add(box);
        box = Box.createVerticalBox();
        box.add(new JLabel(I18N.get("ParamEditWin.arity")));
        buttonGroup = new ButtonGroup();
        this.singleRButton = this.addRadioButton(I18N.get("ParamEditWin.single"), box, buttonGroup);
        this.rangeRButton = this.addRadioButton(I18N.get("ParamEditWin.range"), box, buttonGroup);
        this.listSingleRButton = this.addRadioButton(I18N.get("ParamEditWin.list_single"), box, buttonGroup);
        this.listMultipleRButton = this.addRadioButton(I18N.get("ParamEditWin.list_mult"), box, buttonGroup);
        jPanel.add(box);
        return jPanel;
    }

    protected JPanel buildCardPanel() {
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout(20, 20));
        this.cardPanel.add((Component)this.boolCard(), CARD_NAME_SINGLE_BOOL);
        this.cardPanel.add((Component)this.singleCard(), CARD_NAME_SINGLE);
        this.cardPanel.add((Component)this.rangeCard(), CARD_NAME_RANGE);
        this.cardPanel.add((Component)this.listCard(), CARD_NAME_LIST);
        this.cardPanel.add((Component)this.dateCard(), CARD_NAME_DATE);
        return this.cardPanel;
    }

    protected JPanel dateCard() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(I18N.get("ParamEditWin.date_default")));
        return jPanel;
    }

    protected JPanel boolCard() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        Box box = Box.createVerticalBox();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.boolYesRButton = new JRadioButton(I18N.get("GUI.yes"));
        box.add(this.boolYesRButton);
        buttonGroup.add(this.boolYesRButton);
        this.boolNoRButton = new JRadioButton(I18N.get("GUI.no"));
        box.add(this.boolNoRButton);
        buttonGroup.add(this.boolNoRButton);
        jPanel.add(box);
        return jPanel;
    }

    protected JPanel singleCard() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.add(new JLabel(I18N.get("ParamEditWin.default_value")));
        this.singleField = new JTextField(24);
        jPanel.add(this.singleField);
        return jPanel;
    }

    protected JPanel rangeCard() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        JLabel jLabel = new JLabel(I18N.get("GUI.from"));
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(4);
        jLabel = new JLabel(I18N.get("GUI.to"));
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(4);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        this.rangeFromField = new JTextField(24);
        jPanel3.add(this.rangeFromField);
        this.rangeToField = new JTextField(24);
        jPanel3.add(this.rangeToField);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    protected JPanel listCard() {
        JPanel jPanel = new JPanel();
        Box box = Box.createVerticalBox();
        jPanel.add(box);
        this.list = new JList(new DefaultListModel());
        this.list.setSelectionMode(0);
        box.add(new JScrollPane(this.list));
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(I18N.get("ParamEditWin.add_to_list"));
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        this.listAddField = new JTextField(24);
        jPanel2.add(this.listAddField);
        box.add(jPanel2);
        jButton = new JButton(I18N.get("ParamEditWin.remove_from_list"));
        jButton.addActionListener(this);
        box.add(jButton);
        return jPanel;
    }

    protected JRadioButton addRadioButton(String string, Container container, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.addActionListener(this);
        container.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    protected void fillEditWidgets() {
        this.nameField.setText(this.param.getName());
        this.questionField.setText(this.param.getQuestion());
        int n = this.param.getType();
        switch (n) {
            case 0: {
                this.boolRButton.setSelected(true);
                break;
            }
            case 1: {
                this.stringRButton.setSelected(true);
                break;
            }
            case 2: {
                this.numericRButton.setSelected(true);
                break;
            }
            case 3: {
                this.dateRButton.setSelected(true);
            }
        }
        switch (this.param.getArity()) {
            case 0: {
                this.singleRButton.setSelected(true);
                break;
            }
            case 1: {
                this.rangeRButton.setSelected(true);
                break;
            }
            case 2: {
                this.listSingleRButton.setSelected(true);
                break;
            }
            case 3: {
                this.listMultipleRButton.setSelected(true);
            }
        }
        this.selectAndFillCard();
    }

    protected int typeFromWidgets() {
        if (this.boolRButton.isSelected()) {
            return 0;
        }
        if (this.stringRButton.isSelected()) {
            return 1;
        }
        if (this.numericRButton.isSelected()) {
            return 2;
        }
        return 3;
    }

    protected int arityFromWidgets() {
        if (this.singleRButton.isSelected()) {
            return 0;
        }
        if (this.rangeRButton.isSelected()) {
            return 1;
        }
        if (this.listSingleRButton.isSelected()) {
            return 2;
        }
        return 3;
    }

    protected void enableLegalArityButtons() {
        int n = this.typeFromWidgets();
        this.singleRButton.setEnabled(this.param.isLegal(n, 0));
        this.rangeRButton.setEnabled(this.param.isLegal(n, 1));
        this.listSingleRButton.setEnabled(this.param.isLegal(n, 2));
        this.listMultipleRButton.setEnabled(this.param.isLegal(n, 3));
    }

    protected void selectAndFillCard() {
        this.enableLegalArityButtons();
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        int n = this.typeFromWidgets();
        block0 : switch (this.arityFromWidgets()) {
            case 0: {
                switch (n) {
                    case 0: {
                        cardLayout.show(this.cardPanel, CARD_NAME_SINGLE_BOOL);
                        Object object = this.param.getDefaultValue(0);
                        Boolean bl = null;
                        Boolean bl2 = bl = object instanceof Boolean ? (Boolean)object : (Boolean)this.param.getDefaultForType(n);
                        if (bl != null && bl.booleanValue()) {
                            this.boolYesRButton.setSelected(true);
                            break block0;
                        }
                        this.boolNoRButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        cardLayout.show(this.cardPanel, CARD_NAME_DATE);
                        break block0;
                    }
                }
                cardLayout.show(this.cardPanel, CARD_NAME_SINGLE);
                this.setField(this.singleField, 0);
                break;
            }
            case 1: {
                if (n == 3) {
                    cardLayout.show(this.cardPanel, CARD_NAME_DATE);
                } else {
                    cardLayout.show(this.cardPanel, CARD_NAME_RANGE);
                }
                this.setField(this.rangeFromField, 0);
                this.setField(this.rangeToField, 1);
                break;
            }
            case 2: 
            case 3: {
                cardLayout.show(this.cardPanel, CARD_NAME_LIST);
                DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                defaultListModel.clear();
                Iterator iterator = this.param.defaultValues();
                while (iterator.hasNext()) {
                    defaultListModel.addElement(iterator.next());
                }
                break;
            }
        }
    }

    protected void setField(JTextField jTextField, int n) {
        Object object = this.param.getDefaultValue(n);
        jTextField.setText(object == null ? "" : object.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.typeFromWidgets();
        int n2 = this.arityFromWidgets();
        boolean bl = false;
        if (string.equals(I18N.get("ParamEditWin.bool")) || string.equals(I18N.get("ParamEditWin.text")) || string.equals(I18N.get("ParamEditWin.number")) || string.equals(I18N.get("ParamEditWin.date"))) {
            bl = true;
            if (!this.param.isLegal(n, n2)) {
                this.singleRButton.setSelected(true);
            }
        } else if (string.equals(I18N.get("ParamEditWin.single")) || string.equals(I18N.get("ParamEditWin.range")) || string.equals(I18N.get("ParamEditWin.list_single")) || string.equals(I18N.get("ParamEditWin.list_mult"))) {
            bl = true;
        } else if (string.equals(I18N.get("ParamEditWin.add_to_list"))) {
            ((DefaultListModel)this.list.getModel()).addElement(this.listAddField.getText());
            this.listAddField.setText("");
        } else if (string.equals(I18N.get("ParamEditWin.remove_from_list"))) {
            ((DefaultListModel)this.list.getModel()).removeElement(this.list.getSelectedValue());
        } else {
            super.actionPerformed(actionEvent);
        }
        if (bl) {
            this.selectAndFillCard();
        }
    }

    protected void doSave() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.typeFromWidgets();
        int n2 = this.arityFromWidgets();
        block0 : switch (n2) {
            case 0: {
                switch (n) {
                    case 0: {
                        arrayList.add(this.boolYesRButton.isSelected());
                    }
                    case 3: {
                        break block0;
                    }
                }
                arrayList.add(this.singleField.getText());
                break;
            }
            case 1: {
                arrayList.add(this.rangeFromField.getText());
                arrayList.add(this.rangeToField.getText());
                break;
            }
            case 2: 
            case 3: {
                object = (DefaultListModel)this.list.getModel();
                Enumeration enumeration = ((DefaultListModel)object).elements();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
                break;
            }
        }
        object = new ParamEditCommand(this.param, this.nameField.getText(), this.questionField.getText(), n, n2, arrayList);
        ((ParamEditCommand)object).perform();
        this.commands.add((Command)object);
    }

    protected void doRevert() {
        this.fillEditWidgets();
    }
}

