/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.parameter;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jimm.datavision.Parameter;
import jimm.datavision.gui.parameter.Inquisitor;
import jimm.util.I18N;

public class ParamAskWin
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected static final int HORIZ_GAP = 20;
    protected static final int VERT_GAP = 20;
    protected static final int EDIT_PANEL_WIDTH = 300;
    protected static final int EDIT_PANEL_HEIGHT = 200;
    protected static final int TEXT_FIELD_COLS = 24;
    protected static final int MAX_LIST_VISIBLE = 4;
    protected static final String CARD_BOOL_NAME = "bool";
    protected static final String CARD_SINGLE_STRING_NAME = "single-string";
    protected static final String CARD_RANGE_STRING_NAME = "range-string";
    protected static final String CARD_LIST_SINGLE_STRING_NAME = "list-single-string";
    protected static final String CARD_LIST_MULTIPLE_STRING_NAME = "list-multiple-string";
    protected static final String CARD_SINGLE_DATE_NAME = "single-date";
    protected static final String CARD_RANGE_DATE_NAME = "range-date";
    protected List parameters;
    protected Parameter selectedParameter;
    protected boolean cancelled;
    protected JList questionList;
    protected JPanel cardPanel;
    protected HashMap createdInquisitors;

    public ParamAskWin(Frame frame, List list) {
        super(frame, I18N.get("ParamAskWin.title"), true);
        this.parameters = list;
        this.createdInquisitors = new HashMap();
        this.selectedParameter = null;
        this.buildWindow();
        this.questionList.setSelectedIndex(0);
        this.questionList.setVisibleRowCount(Math.max(list.size(), 4));
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.questionPanel(), "North");
        this.getContentPane().add((Component)this.editPanel(), "Center");
        this.getContentPane().add((Component)this.buttonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ParamAskWin.this.dispose();
                ParamAskWin.this.cancelled = true;
            }
        });
    }

    protected JPanel questionPanel() {
        JPanel jPanel = new JPanel();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.questionList = new JList(defaultListModel);
        this.questionList.addListSelectionListener(this);
        this.questionList.setSelectionMode(0);
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(((Parameter)iterator.next()).getQuestion());
        }
        jPanel.add(new JScrollPane(this.questionList));
        return jPanel;
    }

    protected JPanel editPanel() {
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout(20, 20));
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(300, 200));
        this.cardPanel.add((Component)jPanel, "dummy-blank-panel");
        return this.cardPanel;
    }

    protected JPanel buttonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("ParamAskWin.run_report"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(I18N.get("GUI.cancel"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    public boolean userCancelled() {
        return this.cancelled;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.copyValuesToSelectedParameter();
        int n = this.questionList.getSelectedIndex();
        if (n >= 0) {
            this.selectedParameter = (Parameter)this.parameters.get(n);
            this.selectAndFillCard();
        } else {
            this.selectedParameter = null;
        }
    }

    protected void selectAndFillCard() {
        Inquisitor inquisitor = (Inquisitor)this.createdInquisitors.get(this.selectedParameter);
        if (inquisitor == null) {
            inquisitor = Inquisitor.create(this.selectedParameter);
            this.createdInquisitors.put(this.selectedParameter, inquisitor);
            this.cardPanel.add((Component)inquisitor.getPanel(), inquisitor.getPanelName());
        }
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, inquisitor.getPanelName());
        inquisitor.copyParamIntoGUI();
    }

    protected void copyValuesToSelectedParameter() {
        if (this.selectedParameter != null) {
            Inquisitor inquisitor = (Inquisitor)this.createdInquisitors.get(this.selectedParameter);
            inquisitor.copyGUIIntoParam();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("ParamAskWin.run_report").equals(string)) {
            this.cancelled = false;
            this.copyValuesToSelectedParameter();
            this.dispose();
        } else if (I18N.get("GUI.cancel").equals(string)) {
            this.cancelled = true;
            this.dispose();
        }
    }
}

