/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.parameter;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jimm.datavision.Parameter;
import jimm.datavision.gui.parameter.BoolInq;
import jimm.datavision.gui.parameter.ListNumericInq;
import jimm.datavision.gui.parameter.ListStringInq;
import jimm.datavision.gui.parameter.RangeDateInq;
import jimm.datavision.gui.parameter.RangeNumericInq;
import jimm.datavision.gui.parameter.RangeStringInq;
import jimm.datavision.gui.parameter.SingleDateInq;
import jimm.datavision.gui.parameter.SingleNumericInq;
import jimm.datavision.gui.parameter.SingleStringInq;
import jimm.util.I18N;

abstract class Inquisitor {
    protected static final int TEXT_FIELD_COLS = 24;
    protected static int instanceCount;
    protected Parameter parameter;
    protected JPanel panel;
    protected String panelName;

    public static Inquisitor create(Parameter parameter) {
        if (!parameter.isLegal(parameter.getType(), parameter.getArity())) {
            String string = I18N.get("Inquisitor.param_cap") + ' ' + parameter.getName() + ' ' + I18N.get("Inquisitor.illegal");
            throw new IllegalArgumentException(string);
        }
        switch (parameter.getType()) {
            case 0: {
                return new BoolInq(parameter);
            }
            case 1: {
                switch (parameter.getArity()) {
                    case 0: {
                        return new SingleStringInq(parameter);
                    }
                    case 1: {
                        return new RangeStringInq(parameter);
                    }
                    case 2: {
                        return new ListStringInq(parameter, false);
                    }
                    case 3: {
                        return new ListStringInq(parameter, true);
                    }
                }
                break;
            }
            case 2: {
                switch (parameter.getArity()) {
                    case 0: {
                        return new SingleNumericInq(parameter);
                    }
                    case 1: {
                        return new RangeNumericInq(parameter);
                    }
                    case 2: {
                        return new ListNumericInq(parameter, false);
                    }
                    case 3: {
                        return new ListNumericInq(parameter, true);
                    }
                }
                break;
            }
            case 3: {
                switch (parameter.getArity()) {
                    case 0: {
                        return new SingleDateInq(parameter);
                    }
                    case 1: {
                        return new RangeDateInq(parameter);
                    }
                }
            }
        }
        return null;
    }

    Inquisitor(Parameter parameter) {
        this.parameter = parameter;
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.panelName = "" + instanceCount++;
    }

    JPanel getPanel() {
        return this.panel;
    }

    String getPanelName() {
        return this.panelName;
    }

    abstract void copyGUIIntoParam();

    abstract void copyParamIntoGUI();
}

