/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import javax.swing.JTextPane;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.TextFieldWidget;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.gui.cmd.SectionResizeCommand;
import jimm.util.I18N;

public class TypingCommand
extends CommandAdapter {
    protected TextFieldWidget fw;
    protected SectionWidget sw;
    protected String oldText;
    protected String newText;
    protected Rectangle oldBounds;
    protected Rectangle newBounds;
    protected int origHeight;
    protected SectionResizeCommand sectionResizeCommand;

    public TypingCommand(TextFieldWidget textFieldWidget, int n) {
        super(I18N.get("TypingCommand.name"));
        this.fw = textFieldWidget;
        this.origHeight = n;
        this.sw = textFieldWidget.getSectionWidget();
        this.oldText = (String)textFieldWidget.getField().getValue();
        this.oldBounds = new Rectangle(textFieldWidget.getField().getBounds());
        this.sectionResizeCommand = new SectionResizeCommand(this.sw);
    }

    public void perform() {
        JTextPane jTextPane = (JTextPane)this.fw.getComponent();
        if (jTextPane.isEditable()) {
            this.newText = jTextPane.getText();
            jTextPane.setEditable(false);
            jTextPane.getCaret().setVisible(false);
            this.newBounds = new Rectangle(jTextPane.getBounds());
            if (this.newBounds.height != (double)this.origHeight) {
                this.fw.getField().getBounds().setBounds(this.newBounds);
            }
            this.fw.getField().setValue(this.newText);
            this.fw.getSectionWidget().setIgnoreKeys(false);
            jTextPane.addMouseListener(this.fw);
            jTextPane.addMouseMotionListener(this.fw);
        }
        this.sectionResizeCommand.perform();
    }

    public void undo() {
        this.fw.getField().setValue(this.oldText);
        this.fw.getField().getBounds().setBounds(this.oldBounds);
        this.sectionResizeCommand.undo();
    }

    public void redo() {
        this.fw.getField().setValue(this.newText);
        this.fw.getField().getBounds().setBounds(this.newBounds);
        this.sectionResizeCommand.redo();
    }
}

