/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.source.Query;
import jimm.util.I18N;

public class TableJoinCommand
extends CommandAdapter {
    protected Query query;
    protected Collection newJoins;
    protected Collection origJoins;

    public TableJoinCommand(Query query, Collection collection) {
        super(I18N.get("TableJoinCommand.name"));
        this.query = query;
        this.origJoins = new ArrayList();
        Iterator iterator = query.joins();
        while (iterator.hasNext()) {
            this.origJoins.add(iterator.next());
        }
        this.newJoins = collection;
    }

    public void perform() {
        this.query.clearJoins();
        this.query.addAllJoins(this.newJoins);
    }

    public void undo() {
        this.query.clearJoins();
        this.query.addAllJoins(this.origJoins);
    }
}

