/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jimm.datavision.Selectable;
import jimm.datavision.gui.SortWinListItem;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.source.Query;
import jimm.util.I18N;

public class SortEditCommand
extends CommandAdapter {
    protected static final int NO_CHANGE = 0;
    protected static final int ONLY_SORTING_CHANGE = 1;
    protected static final int DRASTIC_CHANGE = 2;
    protected Query query;
    protected Collection newSortItems;
    protected Collection oldSortItems;

    public SortEditCommand(Query query, Collection collection) {
        super(I18N.get("SortEditCommand.name"));
        this.query = query;
        this.newSortItems = collection;
        this.oldSortItems = new ArrayList();
        Iterator iterator = query.sortedSelectables();
        while (iterator.hasNext()) {
            Selectable selectable = (Selectable)iterator.next();
            this.oldSortItems.add(new SortWinListItem(selectable, query.sortOrderOf(selectable)));
        }
    }

    public void perform() {
        this.setSorts(this.newSortItems);
    }

    public void undo() {
        this.setSorts(this.oldSortItems);
    }

    protected void setSorts(Collection collection) {
        this.query.clearSorts();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SortWinListItem sortWinListItem = (SortWinListItem)iterator.next();
            this.query.addSort(sortWinListItem.getSelectable(), sortWinListItem.sortsAscending() ? 1 : 0);
        }
    }
}

