/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.Formula;
import jimm.datavision.Report;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class ReportStartupScriptEditCommand
extends CommandAdapter {
    protected Report report;
    protected String newExpression;
    protected String oldExpression;
    protected String oldLanguage;
    protected String newLanguage;

    public ReportStartupScriptEditCommand(Report report, String string, String string2) {
        super(I18N.get("ReportStartupScriptEditCommand.name"));
        this.report = report;
        Formula formula = report.getStartFormula();
        this.newExpression = string;
        this.oldExpression = formula == null ? null : formula.getExpression();
        this.newLanguage = string2;
        this.oldLanguage = formula == null ? null : formula.getLanguage();
    }

    public void perform() {
        Formula formula = null;
        if (this.oldExpression == null) {
            formula = new Formula(null, this.report, "", "");
            this.report.setStartFormula(formula);
        } else {
            formula = this.report.getStartFormula();
        }
        formula.setEditableExpression(this.newExpression);
        formula.setLanguage(this.newLanguage);
    }

    public void undo() {
        if (this.oldExpression == null) {
            this.report.setStartFormula(null);
        } else {
            Formula formula = this.report.getStartFormula();
            formula.setEditableExpression(this.oldExpression);
            formula.setLanguage(this.oldLanguage);
        }
    }
}

