/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.PaperFormat;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class PaperSizeCommand
extends CommandAdapter {
    Report report;
    Designer designer;
    PaperFormat origFormat;
    PaperFormat newFormat;

    public PaperSizeCommand(Report report, Designer designer, PaperFormat paperFormat) {
        super(I18N.get("PaperSizeCommand.name"));
        this.report = report;
        this.designer = designer;
        this.origFormat = this.report.getPaperFormat();
        this.newFormat = paperFormat;
    }

    public void perform() {
        this.report.setPaperFormat(this.newFormat);
        this.designer.paperSizeChanged(this.newFormat);
        this.designer.invalidate();
    }

    public void undo() {
        this.report.setPaperFormat(this.origFormat);
        this.designer.paperSizeChanged(this.origFormat);
        this.designer.invalidate();
    }
}

