/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import javax.swing.ImageIcon;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Point;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.ImageFieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.InsertFieldCommand;
import jimm.util.I18N;

public class NewImageFieldCommand
extends InsertFieldCommand {
    protected String imageURL;

    public NewImageFieldCommand(SectionWidget sectionWidget, String string) {
        super(sectionWidget, "image", new Point(0.0, 0.0));
        this.imageURL = string;
    }

    public void perform() {
        super.perform();
        if (!((ImageField)this.fw.getField()).canLoad()) {
            ErrorHandler.error(I18N.get("DesignWin.image_load_err_1") + ' ' + this.imageURL + ' ' + I18N.get("DesignWin.image_load_err_2"), I18N.get("DesignWin.image_load_err_title"));
        }
    }

    protected Rectangle initialFieldBounds() {
        ImageIcon imageIcon = ((ImageField)this.fw.getField()).getImageIcon();
        return new Rectangle(this.insertLoc.x, this.insertLoc.y, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    protected Object initialFieldValue() {
        return this.imageURL;
    }

    protected FieldWidget createFieldWidget(Field field) {
        return new ImageFieldWidget(null, (ImageField)field);
    }
}

