/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.awt.dnd.DropTargetDropEvent;
import jimm.datavision.Point;
import jimm.datavision.Section;
import jimm.datavision.field.ColumnField;
import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.InsertFieldCommand;
import jimm.datavision.gui.cmd.SectionResizeCommand;
import jimm.datavision.source.Column;

public class NewDraggedFieldCommand
extends InsertFieldCommand {
    protected FieldWidget titleField;
    protected SectionResizeCommand titleSectionResizeCommand;

    public NewDraggedFieldCommand(SectionWidget sectionWidget, String string, DropTargetDropEvent dropTargetDropEvent) {
        super(sectionWidget, string, new Point(dropTargetDropEvent.getLocation()));
    }

    public void perform() {
        super.perform();
        SectionWidget sectionWidget = this.fw.getSectionWidget();
        Field field = this.fw.getField();
        if (sectionWidget.getSection().isDetail() && field instanceof ColumnField) {
            Column column = ((ColumnField)field).getColumn();
            String string = column.getName();
            string = string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
            Section section = field.getReport().pageHeaders().first();
            SectionWidget sectionWidget2 = sectionWidget.getDesigner().findSectionWidgetFor(section);
            this.titleSectionResizeCommand = new SectionResizeCommand(sectionWidget2);
            this.titleField = sectionWidget.addTitleField((int)this.insertLoc.getX(), 120, string);
            if (this.titleField != null) {
                this.titleSectionResizeCommand.perform();
            } else {
                this.titleSectionResizeCommand = null;
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.titleField != null) {
            this.titleField.doDelete();
            this.titleSectionResizeCommand.undo();
            this.titleField.getSectionWidget().repaint();
        }
    }

    public void redo() {
        super.redo();
        if (this.titleField != null) {
            this.titleField.moveToSection(this.titleField.getSectionWidget());
        }
    }

    protected Field createField() {
        return Field.createFromDragString(this.sw.getReport(), this.fieldType);
    }

    protected Rectangle initialFieldBounds() {
        return new Rectangle(this.insertLoc.getX(), this.insertLoc.getY(), 120.0, 16.0);
    }

    protected Object initialFieldValue() {
        return null;
    }

    protected FieldWidget createFieldWidget(Field field) {
        return field.makeWidget(null);
    }
}

