/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.Point;
import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.gui.cmd.SectionResizeCommand;
import jimm.util.I18N;

public abstract class InsertFieldCommand
extends CommandAdapter {
    protected FieldWidget fw;
    protected SectionWidget sw;
    protected Point insertLoc;
    protected String fieldType;
    protected SectionResizeCommand sectionResizeCommand;

    public InsertFieldCommand(SectionWidget sectionWidget, String string, Point point) {
        super(I18N.get("InsertFieldCommand.name"));
        this.sw = sectionWidget;
        this.fieldType = string;
        this.insertLoc = point;
        this.sectionResizeCommand = new SectionResizeCommand(sectionWidget);
    }

    public void perform() {
        if (this.fw == null) {
            Field field = this.createField();
            this.fw = this.createFieldWidget(field);
        }
        this.fw.getField().getBounds().setBounds(this.initialFieldBounds());
        this.fw.moveToSection(this.sw);
        this.sectionResizeCommand.perform();
    }

    public void undo() {
        this.sw.removeField(this.fw);
        this.sectionResizeCommand.undo();
        this.sw.repaint();
    }

    protected Field createField() {
        return Field.create(null, this.sw.getReport(), null, this.fieldType, this.initialFieldValue(), true);
    }

    protected abstract Rectangle initialFieldBounds();

    protected abstract Object initialFieldValue();

    protected abstract FieldWidget createFieldWidget(Field var1);
}

