/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jimm.datavision.Group;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.GroupWinListItem;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class GroupEditCommand
extends CommandAdapter {
    protected static final int NO_CHANGE = 0;
    protected static final int ONLY_SORTING_CHANGE = 1;
    protected static final int DRASTIC_CHANGE = 2;
    protected Report report;
    protected Designer designer;
    protected Collection newGroupItems;
    protected Collection oldGroupItems;

    public GroupEditCommand(Report report, Designer designer, Collection collection) {
        super(I18N.get("GroupEditCommand.name"));
        this.report = report;
        this.designer = designer;
        this.newGroupItems = collection;
        this.oldGroupItems = new ArrayList();
        Iterator iterator = this.report.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            this.oldGroupItems.add(new GroupWinListItem(group.getSelectable(), group));
        }
    }

    public void perform() {
        this.setGroups(this.oldGroupItems, this.newGroupItems);
    }

    public void undo() {
        this.setGroups(this.newGroupItems, this.oldGroupItems);
    }

    protected void setGroups(Collection collection, Collection collection2) {
        switch (this.whatChanged(collection, collection2)) {
            case 1: {
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    GroupWinListItem groupWinListItem = (GroupWinListItem)iterator.next();
                    groupWinListItem.getGroup().setSortOrder(groupWinListItem.getSortOrder());
                }
                break;
            }
            case 2: {
                this.report.removeAllGroups();
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    GroupWinListItem groupWinListItem = (GroupWinListItem)iterator.next();
                    Group group = groupWinListItem.getGroup();
                    if (group == null) {
                        group = Group.create(this.report, groupWinListItem.getSelectable());
                    }
                    group.setSortOrder(groupWinListItem.getSortOrder());
                    this.report.addGroup(group);
                }
                this.designer.rebuildGroups();
                break;
            }
        }
    }

    protected int whatChanged(Collection collection, Collection collection2) {
        if (collection.size() != collection2.size()) {
            return 2;
        }
        int n = 0;
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            GroupWinListItem groupWinListItem = (GroupWinListItem)iterator.next();
            GroupWinListItem groupWinListItem2 = (GroupWinListItem)iterator2.next();
            if (groupWinListItem.getGroup() != groupWinListItem2.getGroup()) {
                return 2;
            }
            if (groupWinListItem.sortsAscending() == groupWinListItem2.sortsAscending()) continue;
            n = 1;
        }
        return n;
    }
}

