/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.field.Border;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class FormatCommand
extends CommandAdapter {
    protected Field field;
    protected Format origFormat;
    protected Format newFormat;
    protected Border origBorder;
    protected Border newBorder;

    public FormatCommand(Field field, Format format, Border border) {
        super(I18N.get("FormatCommand.name"));
        this.field = field;
        this.origFormat = this.field.getFormat();
        if (this.origFormat != null) {
            this.origFormat = (Format)this.origFormat.clone();
        }
        this.newFormat = format;
        this.origBorder = this.field.getBorder();
        if (this.origBorder != null) {
            this.origBorder = (Border)this.origBorder.clone();
        }
        this.newBorder = border;
    }

    public void perform() {
        this.field.setFormat(this.newFormat);
        this.field.setBorder(this.newBorder);
    }

    public void undo() {
        this.field.setFormat(this.origFormat);
        this.field.setBorder(this.origBorder);
    }
}

