/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.gui.cmd.SectionResizeCommand;
import jimm.util.I18N;

public class FieldResizeCommand
extends CommandAdapter {
    protected FieldWidget fw;
    protected int which;
    protected Field prototype;
    protected Rectangle origBounds;
    protected SectionResizeCommand sectionResizeCommand;

    public FieldResizeCommand(FieldWidget fieldWidget, int n, Field field) {
        super(I18N.get("FieldResizeCommand.name"));
        this.fw = fieldWidget;
        this.which = n;
        this.prototype = field;
        this.origBounds = new Rectangle(fieldWidget.getField().getBounds());
        this.sectionResizeCommand = new SectionResizeCommand(fieldWidget.getSectionWidget());
    }

    public void perform() {
        this.fw.size(this.which, this.prototype);
        this.fw.getSectionWidget().growToFit();
        this.sectionResizeCommand.perform();
    }

    public void undo() {
        this.fw.getField().getBounds().setBounds(this.origBounds);
        this.sectionResizeCommand.undo();
    }
}

