/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.PreMoveInfo;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.gui.cmd.SectionResizeCommand;
import jimm.util.I18N;

public class FieldMoveCommand
extends CommandAdapter {
    protected FieldWidget fw;
    protected Rectangle newBounds;
    protected SectionWidget newSectionWidget;
    protected SectionResizeCommand sectionResizeCommand;
    protected PreMoveInfo preMoveInfo;

    public FieldMoveCommand(FieldWidget fieldWidget, SectionWidget sectionWidget) {
        super(I18N.get("FieldMoveCommand.name"));
        this.fw = fieldWidget;
        this.preMoveInfo = fieldWidget.getPreMoveInfo();
        this.newBounds = new Rectangle(fieldWidget.getField().getBounds());
        this.newSectionWidget = sectionWidget;
        this.sectionResizeCommand = new SectionResizeCommand(sectionWidget);
    }

    public void perform() {
        this.fw.getField().getBounds().setBounds(this.newBounds);
        this.fw.putDown(this.newSectionWidget);
        this.sectionResizeCommand.perform();
    }

    public void undo() {
        Field field = this.fw.getField();
        SectionWidget sectionWidget = this.fw.getSectionWidget();
        field.getBounds().setBounds(this.preMoveInfo.origBounds);
        this.fw.moveToSection(this.preMoveInfo.sectionWidget);
        this.sectionResizeCommand.undo();
        if (sectionWidget != this.preMoveInfo.sectionWidget) {
            sectionWidget.repaint();
        }
    }
}

