/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.field.Field;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.Pasteable;
import jimm.datavision.gui.cmd.SectionResizeCommand;

public class FieldClipping
implements Pasteable {
    protected Field origField;
    protected FieldWidget newWidget;
    protected SectionWidget origSectionWidget;
    protected SectionArea sectionArea;
    protected SectionResizeCommand sectionResizeCommand;

    public FieldClipping(FieldWidget fieldWidget) {
        this.origField = fieldWidget.getField();
        this.origSectionWidget = fieldWidget.getSectionWidget();
        this.sectionArea = this.origSectionWidget.getSectionArea();
    }

    public void paste(Designer designer) {
        Report report = designer.getReport();
        Report report2 = this.origSectionWidget.getReport();
        SectionWidget sectionWidget = null;
        sectionWidget = report == report2 ? (report.contains(this.origSectionWidget.getSection()) ? this.origSectionWidget : this.sectionWidgetBySectionArea(designer)) : this.sectionWidgetBySectionArea(designer);
        Field field = (Field)this.origField.clone();
        this.newWidget = field.makeWidget(sectionWidget);
        this.sectionResizeCommand = new SectionResizeCommand(sectionWidget);
        this.newWidget.moveToSection(sectionWidget);
        this.sectionResizeCommand.perform();
        designer.select(this.newWidget, true, false);
    }

    protected SectionWidget sectionWidgetBySectionArea(Designer designer) {
        Report report = designer.getReport();
        Section section = report.getFirstSectionByArea(this.sectionArea.getArea());
        if (section == null) {
            section = report.getFirstSectionByArea(0);
        }
        return designer.findSectionWidgetFor(section);
    }

    public void undo(Designer designer) {
        this.newWidget.doDelete();
        this.sectionResizeCommand.undo();
        designer.enableMenuItems();
    }
}

