/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FPLeafInfo;
import jimm.datavision.gui.FieldPickerTree;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class FPDeleteCommand
extends CommandAdapter {
    protected Report report;
    protected Designer designer;
    protected FieldPickerTree tree;
    protected DefaultMutableTreeNode leafNode;
    protected MutableTreeNode parentNode;
    protected FPLeafInfo info;

    public FPDeleteCommand(Report report, Designer designer, FieldPickerTree fieldPickerTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        this(report, designer, fieldPickerTree, defaultMutableTreeNode, I18N.get("FPDeleteCommand.name"));
    }

    protected FPDeleteCommand(Report report, Designer designer, FieldPickerTree fieldPickerTree, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        super(string);
        this.report = report;
        this.designer = designer;
        this.tree = fieldPickerTree;
        this.leafNode = defaultMutableTreeNode;
        this.parentNode = (MutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FPLeafInfo) {
            this.info = (FPLeafInfo)object;
        }
    }

    public void perform() {
        if (this.info != null) {
            this.report.remove(this.info.getLeaf());
            this.tree.removeCurrentNode();
        }
    }

    public void undo() {
        if (this.info != null) {
            this.report.add(this.info.getLeaf());
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(this.leafNode, this.parentNode, this.parentNode.getChildCount());
            TreePath treePath = new TreePath(this.leafNode.getPath());
            this.tree.scrollPathToVisible(treePath);
            this.tree.setSelectionPath(treePath);
        }
    }
}

