/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.Report;
import jimm.datavision.ReportSectionLoc;
import jimm.datavision.Section;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class DeleteSectionCommand
extends CommandAdapter {
    protected Designer designer;
    protected Report report;
    protected Section section;
    protected ReportSectionLoc sectionLoc;
    protected SectionWidget sectionWidget;
    protected SectionWidget sectionWidgetAbove;

    public DeleteSectionCommand(Designer designer, Report report, Section section) {
        super(I18N.get("DeleteSectionCommand.name"));
        this.designer = designer;
        this.report = report;
        this.section = section;
        this.sectionWidget = designer.findSectionWidgetFor(section);
        this.sectionLoc = report.getSectionLocation(section);
    }

    public void perform() {
        this.sectionWidgetAbove = this.designer.doDeleteSection(this.section);
    }

    public void undo() {
        this.report.reinsertSection(this.sectionLoc);
        this.designer.insertSectionWidgetAfter(this.sectionWidget, this.sectionWidgetAbove);
    }
}

