/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.util.I18N;

public class DeleteCommand
extends CommandAdapter {
    protected Designer designer;
    protected Collection fieldWidgets;

    public DeleteCommand(Designer designer, ArrayList arrayList) {
        this(designer, arrayList, I18N.get("DeleteCommand.name"));
    }

    protected DeleteCommand(Designer designer, ArrayList arrayList, String string) {
        super(string);
        this.designer = designer;
        this.fieldWidgets = (ArrayList)arrayList.clone();
    }

    public void perform() {
        HashSet<SectionWidget> hashSet = new HashSet<SectionWidget>();
        this.designer.deselectAll();
        Iterator iterator = this.fieldWidgets.iterator();
        while (iterator.hasNext()) {
            FieldWidget fieldWidget = (FieldWidget)iterator.next();
            fieldWidget.doDelete();
            hashSet.add(fieldWidget.getSectionWidget());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((SectionWidget)iterator.next()).repaint();
        }
        this.designer.enableMenuItems();
    }

    public void undo() {
        Iterator iterator = this.fieldWidgets.iterator();
        while (iterator.hasNext()) {
            FieldWidget fieldWidget = (FieldWidget)iterator.next();
            fieldWidget.moveToSection(fieldWidget.getSectionWidget());
            this.designer.select(fieldWidget, true, false);
        }
    }
}

