/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.source.sql.Database;
import jimm.util.I18N;

public class DbConnCommand
extends CommandAdapter {
    protected Report report;
    protected Database origDatabase;
    protected String driverClassName;
    protected String connInfo;
    protected String dbName;
    protected String username;
    private String password;

    public DbConnCommand(Report report, String string, String string2, String string3, String string4, String string5) {
        super(I18N.get("DbConnCommand.name"));
        this.origDatabase = (Database)report.getDataSource();
        this.report = report;
        this.driverClassName = string;
        this.connInfo = string2;
        this.dbName = string3;
        this.username = string4 == null ? "" : string4;
        this.password = string5;
    }

    public void perform() {
        Database database = this.origDatabase;
        try {
            if (database == null) {
                database = new Database(this.driverClassName, this.connInfo, this.report, this.dbName, this.username, this.password);
                this.report.setDataSource(database);
            } else {
                database.reset(this.driverClassName, this.connInfo, this.dbName, this.username, this.password);
            }
        }
        catch (Exception exception) {
            ErrorHandler.error(exception, I18N.get("DbConnWin.connect_error"));
        }
    }

    public void undo() {
        try {
            if (this.origDatabase == null) {
                this.report.setDataSource(null);
            } else {
                this.origDatabase.reset(this.driverClassName, this.connInfo, this.dbName, this.username, this.password);
            }
        }
        catch (Exception exception) {
            ErrorHandler.error(I18N.get("DbConnWin.revert_error") + "\n" + exception, I18N.get("DbConnWin.revert_error_title"));
        }
    }
}

