/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.util.ArrayList;
import javax.swing.JMenuItem;
import jimm.datavision.gui.cmd.Command;
import jimm.util.I18N;

public class CommandHistory {
    protected ArrayList commands;
    protected int commandIndex;
    protected int baselineIndex;
    protected JMenuItem undoMenuItem;
    protected JMenuItem redoMenuItem;

    public CommandHistory() {
        this(null, null);
    }

    public CommandHistory(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
        this.undoMenuItem = jMenuItem;
        this.redoMenuItem = jMenuItem2;
        this.commands = new ArrayList();
        this.commandIndex = 0;
        this.baselineIndex = 0;
    }

    public void setMenuItems(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
        this.undoMenuItem = jMenuItem;
        this.redoMenuItem = jMenuItem2;
    }

    public boolean canUndo() {
        return this.commandIndex > 0;
    }

    public boolean canRedo() {
        return this.commandIndex < this.commands.size();
    }

    public void setBaseline() {
        this.baselineIndex = this.commandIndex;
    }

    public boolean isChanged() {
        return this.baselineIndex != this.commandIndex;
    }

    public synchronized void add(Command command) {
        for (int i = this.commands.size() - 1; i >= this.commandIndex; --i) {
            this.commands.remove(i);
        }
        this.commands.add(command);
        ++this.commandIndex;
        this.updateMenu();
    }

    public synchronized void perform(Command command) {
        command.perform();
        this.add(command);
    }

    public synchronized void undo() {
        if (this.commandIndex > 0) {
            --this.commandIndex;
            ((Command)this.commands.get(this.commandIndex)).undo();
            this.updateMenu();
        }
    }

    public synchronized void redo() {
        if (this.commandIndex < this.commands.size()) {
            ((Command)this.commands.get(this.commandIndex)).redo();
            ++this.commandIndex;
            this.updateMenu();
        }
    }

    public String getUndoName() {
        return this.commandIndex > 0 ? this.getCommandName(this.commandIndex - 1) : null;
    }

    public String getRedoName() {
        return this.commandIndex < this.commands.size() ? this.getCommandName(this.commandIndex) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommandName(int n) {
        Command command = null;
        CommandHistory commandHistory = this;
        synchronized (commandHistory) {
            command = (Command)this.commands.get(n);
        }
        return command != null ? command.getName() : null;
    }

    protected void updateMenu() {
        if (this.undoMenuItem != null) {
            this.updateMenuItem(this.undoMenuItem, I18N.get("CommandHistory.undo"), this.getUndoName(), this.canUndo());
        }
        if (this.redoMenuItem != null) {
            this.updateMenuItem(this.redoMenuItem, I18N.get("CommandHistory.redo"), this.getRedoName(), this.canRedo());
        }
    }

    protected void updateMenuItem(JMenuItem jMenuItem, String string, String string2, boolean bl) {
        if (bl) {
            jMenuItem.setText(string + " " + string2);
        } else {
            jMenuItem.setText(string);
        }
        jMenuItem.setEnabled(bl);
    }
}

