/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.cmd;

import java.awt.Container;
import jimm.datavision.Group;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.field.AggregateField;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.CommandAdapter;

public class AbstractAggregateCommand
extends CommandAdapter {
    protected Report report;
    protected FieldWidget fieldWidget;
    protected Group group;
    protected FieldWidget aggregateWidget;
    protected String functionName;

    public AbstractAggregateCommand(Report report, FieldWidget fieldWidget, Group group, String string, String string2) {
        super(string2);
        this.report = report;
        this.fieldWidget = fieldWidget;
        this.group = group;
        this.functionName = string;
    }

    public FieldWidget getAggregateWidget() {
        return this.aggregateWidget;
    }

    protected void createAggregate() {
        Section section = this.group == null ? this.report.footers().first() : this.group.footers().first();
        Field field = this.fieldWidget.getField();
        Object object = field.getId();
        AggregateField aggregateField = (AggregateField)Field.create(null, this.report, section, this.functionName, object, true);
        aggregateField.setGroup(this.group);
        Format format = null;
        Rectangle rectangle = null;
        if (this.aggregateWidget == null) {
            format = field.getFormat();
            format = (Format)format.clone();
            format.setBold(true);
            rectangle = new Rectangle(field.getBounds());
        } else {
            format = this.aggregateWidget.getField().getFormat();
            format = (Format)format.clone();
            rectangle = new Rectangle(this.aggregateWidget.getField().getBounds());
        }
        aggregateField.setFormat(format);
        aggregateField.setBounds(rectangle);
        section.addField(aggregateField);
        SectionWidget sectionWidget = Designer.findWindowFor(this.report).findSectionWidgetFor(section);
        this.aggregateWidget = new FieldWidget(null, aggregateField);
        sectionWidget.addField(this.aggregateWidget);
        sectionWidget.repaint();
    }

    protected void deleteAggregate() {
        Container container = this.aggregateWidget.getComponent().getParent();
        this.aggregateWidget.doDelete();
        container.repaint();
    }
}

