/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.applet;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.AskStringDialog;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.applet.DVApplet;
import jimm.util.I18N;
import jimm.util.XMLWriter;
import org.xml.sax.InputSource;

class DesignApplet
extends Designer {
    DesignApplet(DVApplet dVApplet) {
        super(null, null, dVApplet, null);
        this.reportFilePath = this.getAppletViaCheapTrick().getSaveURL();
    }

    protected boolean readReport(String string, String string2) {
        this.report = new Report();
        String string3 = this.getAppletViaCheapTrick().getReportURL();
        try {
            if (string3 != null && string3.length() > 0) {
                this.report.read(new InputSource(string3));
            }
        }
        catch (Exception exception) {
            ErrorHandler.error(exception);
        }
        this.reportFilePath = null;
        return false;
    }

    protected DVApplet getAppletViaCheapTrick() {
        return (DVApplet)this.rootPaneContainer;
    }

    protected void saveReportAs() {
        String string = new AskStringDialog(this.getFrame(), I18N.get("DesignApplet.new_url_title"), I18N.get("DesignApplet.new_url_prompt"), this.reportFilePath).getString();
        if (string != null) {
            this.reportFilePath = string;
            this.writeReportFile(this.reportFilePath);
        }
    }

    protected void writeReportFile(String string) {
        URLConnection uRLConnection = null;
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            this.sendData(uRLConnection);
            this.receiveResponse(uRLConnection);
        }
        catch (Exception exception) {
            ErrorHandler.error(exception);
        }
        this.commandHistory.setBaseline();
    }

    protected void sendData(URLConnection uRLConnection) throws IOException {
        XMLWriter xMLWriter = null;
        try {
            xMLWriter = new XMLWriter(uRLConnection.getOutputStream());
            this.report.writeXML(xMLWriter);
            xMLWriter.flush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (xMLWriter != null) {
                xMLWriter.close();
            }
        }
    }

    protected void receiveResponse(URLConnection uRLConnection) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            char[] cArray = new char[1024];
            while (inputStreamReader.read(cArray) > 0) {
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
    }
}

