/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Report;
import jimm.datavision.UserColumn;
import jimm.datavision.gui.CodeEditorWin;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.cmd.UserColumnEditCommand;
import jimm.util.I18N;

public class UserColumnWin
extends CodeEditorWin
implements Observer {
    protected UserColumn userColumn;

    public UserColumnWin(Designer designer, Report report, UserColumn userColumn) {
        super(designer, report, userColumn.getEditableExpression(), I18N.get("UserColumnWin.title_prefix") + ' ' + userColumn.getName(), "UserColumnWin.error_unchanged", "UserColumnWin.error_title");
        this.userColumn = userColumn;
        userColumn.addObserver(this);
    }

    protected void finalize() throws Throwable {
        this.userColumn.deleteObserver(this);
        super.finalize();
    }

    public void update(Observable observable, Object object) {
        this.setTitle(I18N.get("UserColumnWin.title_prefix") + ' ' + this.userColumn.getName());
        this.codeField.setText(this.userColumn.getEditableExpression());
    }

    public void save(String string) {
        this.userColumn.deleteObserver(this);
        this.command = new UserColumnEditCommand(this.userColumn, string);
    }
}

