/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.SortedListModel;
import jimm.datavision.gui.TLWListItem;
import jimm.util.I18N;

public abstract class TwoListWin
extends EditWin
implements ActionListener,
ListSelectionListener {
    protected static final String PROTOTYPE_CELL_VALUE = "table_name.column_name";
    protected Report report;
    protected SortedListModel leftModel;
    protected DefaultListModel rightModel;
    protected JList leftList;
    protected JList rightList;
    protected JButton addOne;
    protected JButton addAll;
    protected JButton removeOne;
    protected JButton removeAll;
    protected JButton moveUp;
    protected JButton moveDown;
    protected JRadioButton ascendingRButton;
    protected JRadioButton descendingRButton;

    public TwoListWin(Designer designer, String string, String string2, String string3, Report report) {
        super(designer, string, string2);
        this.report = report;
        this.leftModel = new SortedListModel();
        this.rightModel = new DefaultListModel();
        this.fillListModels();
        this.buildWindow(string3);
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow(String string) {
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(32));
        this.addOne = new JButton(">");
        this.addOne.addActionListener(this);
        box.add(this.addOne);
        this.addAll = new JButton(">>>");
        this.addAll.addActionListener(this);
        box.add(this.addAll);
        this.removeOne = new JButton("<");
        this.removeOne.addActionListener(this);
        box.add(this.removeOne);
        this.removeAll = new JButton("<<<");
        this.removeAll.addActionListener(this);
        box.add(this.removeAll);
        JPanel jPanel = new JPanel();
        jPanel.add(box);
        box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(32));
        this.moveUp = new JButton(I18N.get("TwoListWin.move_up"));
        this.moveUp.addActionListener(this);
        box.add(this.moveUp);
        this.moveDown = new JButton(I18N.get("TwoListWin.move_down"));
        this.moveDown.addActionListener(this);
        box.add(this.moveDown);
        box.add(Box.createVerticalStrut(32));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ascendingRButton = new JRadioButton(I18N.get("GUI.ascending"));
        this.ascendingRButton.addActionListener(this);
        box.add(this.ascendingRButton);
        buttonGroup.add(this.ascendingRButton);
        this.descendingRButton = new JRadioButton(I18N.get("GUI.descending"));
        this.descendingRButton.addActionListener(this);
        box.add(this.descendingRButton);
        buttonGroup.add(this.descendingRButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(box);
        this.leftList = new JList(this.leftModel);
        this.leftList.addListSelectionListener(this);
        this.leftList.setPrototypeCellValue(PROTOTYPE_CELL_VALUE);
        this.leftList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TwoListWin.this.moveToRight(TwoListWin.this.leftList.locationToIndex(mouseEvent.getPoint()));
                }
            }
        });
        Box box2 = Box.createVerticalBox();
        box2.add(new JLabel(I18N.get("TwoListWin.columns")));
        box2.add(new JScrollPane(this.leftList));
        this.rightList = new JList(this.rightModel);
        this.rightList.addListSelectionListener(this);
        this.rightList.setPrototypeCellValue(PROTOTYPE_CELL_VALUE);
        this.rightList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TwoListWin.this.moveToLeft(TwoListWin.this.rightList.locationToIndex(mouseEvent.getPoint()));
                }
            }
        });
        Box box3 = Box.createVerticalBox();
        box3.add(new JLabel(I18N.get(string)));
        box3.add(new JScrollPane(this.rightList));
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalStrut(12));
        box4.add(box2);
        box4.add(jPanel);
        box4.add(box3);
        box4.add(jPanel2);
        box4.add(Box.createHorizontalStrut(12));
        JPanel jPanel3 = this.closeButtonPanel();
        this.getContentPane().add((Component)box4, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.adjustButtons();
    }

    protected abstract void fillListModels();

    protected void moveToRight(int n) {
        this.moveToRight(n, true);
    }

    protected void moveToRight(int n, boolean bl) {
        TLWListItem tLWListItem = (TLWListItem)this.leftModel.getElementAt(n);
        this.leftModel.remove(n);
        this.rightModel.addElement(tLWListItem);
        if (bl) {
            this.adjustButtons();
        }
    }

    protected void moveToLeft(int n) {
        this.moveToLeft(n, true);
    }

    protected void moveToLeft(int n, boolean bl) {
        TLWListItem tLWListItem = (TLWListItem)this.rightModel.elementAt(n);
        this.rightModel.removeElementAt(n);
        this.leftModel.add(tLWListItem);
        if (bl) {
            this.adjustButtons();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.leftList.getModel();
        DefaultListModel defaultListModel = (DefaultListModel)this.rightList.getModel();
        String string = actionEvent.getActionCommand();
        if (string.equals(">")) {
            int[] nArray = this.leftList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.moveToRight(nArray[i], false);
            }
            this.adjustButtons();
        } else if (string.equals(">>>")) {
            Object[] objectArray = sortedListModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                defaultListModel.addElement(objectArray[i]);
            }
            sortedListModel.removeAllElements();
            this.adjustButtons();
        } else if (string.equals("<")) {
            int[] nArray = this.rightList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this.moveToLeft(nArray[i], false);
            }
            this.adjustButtons();
        } else if (string.equals("<<<")) {
            Object[] objectArray = defaultListModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                sortedListModel.add((TLWListItem)objectArray[i]);
            }
            defaultListModel.removeAllElements();
            this.adjustButtons();
        } else if (string.equals(I18N.get("TwoListWin.move_up"))) {
            int n = this.rightList.getSelectedIndex();
            Object e = defaultListModel.remove(n);
            defaultListModel.add(n - 1, e);
            this.rightList.setSelectedIndex(n - 1);
        } else if (string.equals(I18N.get("TwoListWin.move_down"))) {
            int n = this.rightList.getSelectedIndex();
            Object e = defaultListModel.remove(n);
            defaultListModel.add(n + 1, e);
            this.rightList.setSelectedIndex(n + 1);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.adjustButtons();
    }

    protected void adjustButtons() {
        this.addOne.setEnabled(!this.leftList.isSelectionEmpty());
        this.addAll.setEnabled(this.leftList.getModel().getSize() > 0);
        boolean bl = this.rightList.isSelectionEmpty();
        if (bl) {
            this.removeOne.setEnabled(false);
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
            this.ascendingRButton.setEnabled(false);
            this.descendingRButton.setEnabled(false);
            this.ascendingRButton.setSelected(false);
            this.descendingRButton.setSelected(false);
        } else {
            this.removeOne.setEnabled(true);
            int[] nArray = this.rightList.getSelectedIndices();
            if (nArray.length == 1) {
                int n = this.rightModel.size();
                if (n > 1) {
                    int n2 = nArray[0];
                    this.moveUp.setEnabled(n2 != 0);
                    this.moveDown.setEnabled(n2 != n - 1);
                } else {
                    this.moveUp.setEnabled(false);
                    this.moveDown.setEnabled(false);
                }
                this.ascendingRButton.setEnabled(true);
                this.descendingRButton.setEnabled(true);
                TLWListItem tLWListItem = (TLWListItem)this.rightList.getSelectedValue();
                if (tLWListItem.sortsAscending()) {
                    this.ascendingRButton.setSelected(true);
                } else {
                    this.descendingRButton.setSelected(true);
                }
            } else {
                this.moveUp.setEnabled(false);
                this.moveDown.setEnabled(false);
                this.ascendingRButton.setEnabled(false);
                this.descendingRButton.setEnabled(false);
                this.ascendingRButton.setSelected(false);
                this.descendingRButton.setSelected(false);
            }
        }
        this.removeAll.setEnabled(this.rightList.getModel().getSize() > 0);
    }
}

