/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jimm.datavision.field.Field;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.TypingCommand;
import jimm.util.I18N;

public class TextFieldWidget
extends FieldWidget {
    protected int origHeight;
    protected int lineHeight;
    protected boolean changingEditState;
    protected TypingCommand typingCommand;

    public TextFieldWidget(SectionWidget sectionWidget, Field field) {
        super(sectionWidget, field);
        Font font = field.getFormat().getFont();
        FontMetrics fontMetrics = this.swingField.getComponent().getFontMetrics(font);
        this.lineHeight = fontMetrics.getHeight();
    }

    protected String getPopupNameText() {
        return I18N.get("menu", "TextFieldWidget.popup_name");
    }

    protected void addCustomPopupItems() {
        MenuUtils.addToMenu((ActionListener)this, this.popup, "TextFieldWidget.popup_edit", POPUP_FONT);
        this.popup.addSeparator();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if ("edit".equals(string)) {
            this.startEditing();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.startEditing();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEditing() {
        Object object = this;
        synchronized (object) {
            if (this.changingEditState) {
                return;
            }
            this.changingEditState = true;
        }
        if (!this.selected) {
            this.select(true);
        }
        object = (JTextPane)this.getComponent();
        ((JTextComponent)object).setEditable(true);
        ((JTextComponent)object).getCaret().setVisible(true);
        ((JComponent)object).requestFocus();
        this.origHeight = ((Component)object).getBounds().height;
        this.sectionWidget.designer.setIgnoreKeys(true);
        ((Component)object).removeMouseListener(this);
        ((Component)object).removeMouseMotionListener(this);
        this.changingEditState = false;
        this.typingCommand = new TypingCommand(this, this.origHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endEditing() {
        TextFieldWidget textFieldWidget = this;
        synchronized (textFieldWidget) {
            if (this.changingEditState) {
                return;
            }
            this.changingEditState = true;
        }
        if (this.typingCommand != null) {
            this.getSectionWidget().performCommand(this.typingCommand);
            this.typingCommand = null;
        }
        this.changingEditState = false;
    }

    protected void doSelect(boolean bl) {
        if (!bl) {
            this.endEditing();
        }
        super.doSelect(bl);
    }

    protected void cursorForPosition(MouseEvent mouseEvent) {
        JTextPane jTextPane = (JTextPane)this.getComponent();
        if (jTextPane.isEditable()) {
            jTextPane.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            super.cursorForPosition(mouseEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        JTextPane jTextPane = (JTextPane)this.getComponent();
        switch (c) {
            case '\n': {
                Rectangle rectangle = this.getComponent().getBounds();
                rectangle.height += this.lineHeight;
                this.getComponent().setBounds(rectangle);
                this.sectionWidget.growToFit();
                break;
            }
            case '\b': {
                try {
                    int n = jTextPane.getCaretPosition();
                    if (n <= 0 || !jTextPane.getText(n - 1, 1).equals("\n")) break;
                    Rectangle rectangle = jTextPane.getBounds();
                    rectangle.height -= this.lineHeight;
                    jTextPane.setBounds(rectangle);
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case '\u007f': {
                try {
                    int n = jTextPane.getCaretPosition();
                    if (n >= jTextPane.getText().length() || !jTextPane.getText(n, 1).equals("\n")) break;
                    Rectangle rectangle = jTextPane.getBounds();
                    rectangle.height -= this.lineHeight;
                    jTextPane.setBounds(rectangle);
                    break;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

