/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.ScriptEditorWin;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.SuppressionProcEditCommand;
import jimm.util.I18N;

public class SuppressionProcWin
extends ScriptEditorWin {
    protected static final int CHECK_BOX_INDENT_WIDTH = 32;
    protected SectionWidget sectionWidget;
    protected JCheckBox hideCheckBox;

    public SuppressionProcWin(Designer designer, SectionWidget sectionWidget) {
        super(designer, sectionWidget.getSection().getReport(), sectionWidget.getSection().getSuppressionProc().getFormula().getEditableExpression(), I18N.get("SuppressionProcWin.title"), "SuppressionProcWin.error_unchanged", "SuppressionProcWin.error_title");
        this.hideCheckBox.setSelected(sectionWidget.getSection().getSuppressionProc().isHidden());
        this.enableEditBox();
        this.sectionWidget = sectionWidget;
        this.setLanguage(sectionWidget.getSection().getSuppressionProc().getFormula().getLanguage());
    }

    protected JComponent northPanel(Report report) {
        this.hideCheckBox = new JCheckBox(I18N.get("SuppressionProcWin.always_hide"));
        this.hideCheckBox.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(32));
        box.add(this.hideCheckBox);
        JPanel jPanel = new JPanel();
        jPanel.add((Component)box, "West");
        jPanel.add((Component)super.northPanel(report), "East");
        return jPanel;
    }

    public void save(String string) {
        this.command = new SuppressionProcEditCommand(this.sectionWidget, this.hideCheckBox.isSelected(), string, this.getLanguage());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("SuppressionProcWin.always_hide").equals(string)) {
            this.enableEditBox();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void enableEditBox() {
        boolean bl = this.hideCheckBox.isSelected();
        this.codeField.setEditable(!bl);
        this.codeField.setBackground(bl ? Color.lightGray : Color.white);
    }
}

