/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import jimm.util.I18N;

public class StartupDialog
extends JDialog
implements ActionListener {
    public static final String NEW_REPORT_STRING = "*StartANewReport*";
    protected static final String TITLE_IMAGE = "images/DVTitle.png";
    private JButton newReport = new JButton(I18N.get("StartupDialog.new"));
    private JButton existingReport = new JButton(I18N.get("StartupDialog.open"));
    private JButton quit = new JButton(I18N.get("StartupDialog.quit"));
    private JButton titleImage = null;
    private String selectedFile = null;

    public StartupDialog() {
        super((Frame)null, I18N.get("StartupDialog.title"), true);
        this.setResizable(false);
        this.setSize(580, 420);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StartupDialog.this.dispose();
            }
        });
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Dimension dimension2 = this.getSize();
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        int n5 = (n - n3) / 2;
        int n6 = (n2 - n4) / 2;
        this.setLocation(n5, n6);
        URL uRL = this.getClass().getClassLoader().getResource(TITLE_IMAGE);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        JPanel jPanel = new JPanel();
        this.titleImage = new JButton(new ImageIcon(image));
        this.titleImage.setBorderPainted(false);
        this.titleImage.setContentAreaFilled(false);
        this.titleImage.setFocusPainted(false);
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        jPanel.add(this.titleImage);
        this.getContentPane().add("Center", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 50, 10));
        this.newReport.addActionListener(this);
        jPanel2.add(this.newReport);
        this.existingReport.addActionListener(this);
        jPanel2.add(this.existingReport);
        this.quit.addActionListener(this);
        jPanel2.add(this.quit);
        this.getContentPane().add("South", jPanel2);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase(I18N.get("StartupDialog.open"))) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.selectedFile = jFileChooser.getSelectedFile().getPath();
                this.dispose();
            }
        } else if (string.equalsIgnoreCase(I18N.get("StartupDialog.new"))) {
            this.selectedFile = NEW_REPORT_STRING;
            this.dispose();
        } else if (string.equalsIgnoreCase(I18N.get("StartupDialog.quit"))) {
            this.dispose();
            System.exit(0);
        }
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }
}

