/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import jimm.datavision.Nameable;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.UserColumn;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.SortWinListItem;
import jimm.datavision.gui.TwoListWin;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.SortEditCommand;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Query;
import jimm.util.I18N;

public class SortWin
extends TwoListWin {
    protected Query query;

    public SortWin(Designer designer, Report report) {
        super(designer, I18N.get("SortWin.title"), "SortChangeCommand.name", "SortWin.right_box_title", report);
    }

    protected void fillListModels() {
        Nameable nameable;
        DataSource dataSource = this.report.getDataSource();
        this.query = dataSource.getQuery();
        Iterator iterator = this.report.userColumns();
        while (iterator.hasNext()) {
            nameable = (UserColumn)iterator.next();
            if (this.report.isUsedBySomeGroup((Selectable)((Object)nameable))) continue;
            this.addToModel((Selectable)((Object)nameable));
        }
        iterator = dataSource.columnsInTablesUsedInReport();
        while (iterator.hasNext()) {
            nameable = (Column)iterator.next();
            if (this.report.isUsedBySomeGroup((Selectable)((Object)nameable))) continue;
            this.addToModel((Selectable)((Object)nameable));
        }
    }

    protected void addToModel(Selectable selectable) {
        int n = this.query.sortOrderOf(selectable);
        SortWinListItem sortWinListItem = new SortWinListItem(selectable, n);
        if (n == -1) {
            this.leftModel.add(sortWinListItem);
        } else {
            this.rightModel.addElement(sortWinListItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(I18N.get("GUI.ascending"))) {
            ((SortWinListItem)this.rightList.getSelectedValue()).sortOrder = 97;
        } else if (string.equals(I18N.get("GUI.descending"))) {
            ((SortWinListItem)this.rightList.getSelectedValue()).sortOrder = 100;
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void doSave() {
        ArrayList arrayList = new ArrayList();
        Object object = this.rightModel.elements();
        while (object.hasMoreElements()) {
            arrayList.add(object.nextElement());
        }
        object = new SortEditCommand(this.query, arrayList);
        ((SortEditCommand)object).perform();
        this.commands.add((Command)object);
    }

    protected void doRevert() {
        this.leftModel.removeAllElements();
        this.rightModel.removeAllElements();
        this.fillListModels();
        this.adjustButtons();
    }
}

