/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.SectionFieldPanel;
import jimm.datavision.gui.SectionLayout;
import jimm.datavision.gui.SectionNameLabel;
import jimm.datavision.gui.SectionResizer;
import jimm.datavision.gui.SuppressionProcWin;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.SectionPageBreakCommand;
import jimm.datavision.gui.cmd.SectionResizeCommand;

public class SectionWidget
extends JPanel
implements ActionListener {
    public static final int LHS_WIDTH = 125;
    protected static final Font DEFAULT_POPUP_FONT = new Font("Serif", 0, 10);
    static final Color NORMAL_COLOR = Color.white;
    static final Color SUPPRESSED_COLOR = Color.lightGray;
    protected String name;
    protected String popupName;
    protected Designer designer;
    protected Section section;
    protected SectionNameLabel label;
    protected SectionFieldPanel fieldPanel;
    protected JPopupMenu popup;
    protected JMenuItem nameItem;
    protected JMenuItem editSuppress;
    protected JCheckBoxMenuItem togglePageBreak;
    protected JMenuItem deleteGroup;
    protected JMenuItem addGroup;
    protected JMenuItem deleteSection;
    protected JMenuItem insertSection;

    public SectionWidget(Designer designer, Section section, String string) {
        this.designer = designer;
        this.section = section;
        this.name = string;
        this.popupName = "";
        this.setLayout(new SectionLayout());
        this.setPreferredSize(new Dimension(this.getTotalWidth(), this.getHeight()));
        this.buildPopupMenu();
        this.addMouseListener(new PopupListener());
        this.buildDisplayName();
        this.fieldPanel = new SectionFieldPanel(this);
        this.fieldPanel.setLayout(null);
        this.add(this.fieldPanel);
        Iterator iterator = this.section.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            FieldWidget fieldWidget = field.makeWidget(this);
            this.fieldPanel.add((Component)fieldWidget.getComponent(), 0);
        }
        this.fieldPanel.setHidden(this.section.isHidden());
        this.fieldPanel.addMouseListener(new PopupListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SectionWidget.this.deselectAll();
                if (SectionWidget.this.designer.isPlacingNewTextField()) {
                    SectionWidget.this.createNewTextField(mouseEvent);
                }
            }
        });
        this.add(new SectionResizer(this, this.designer.sectionContainer));
    }

    protected void buildPopupMenu() {
        this.popup = new JPopupMenu(this.popupName);
        this.nameItem = MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_dummy_title", DEFAULT_POPUP_FONT);
        this.popup.addSeparator();
        this.editSuppress = MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_suppress", DEFAULT_POPUP_FONT);
        this.togglePageBreak = MenuUtils.addCheckboxToMenu((ActionListener)this, this.popup, "SectionWidget.popup_page_break", DEFAULT_POPUP_FONT);
        this.popup.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_shrink", DEFAULT_POPUP_FONT);
        this.popup.addSeparator();
        this.deleteGroup = MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_delete_group", DEFAULT_POPUP_FONT);
        this.addGroup = MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_add_group", DEFAULT_POPUP_FONT);
        this.popup.addSeparator();
        this.deleteSection = MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_delete_section", DEFAULT_POPUP_FONT);
        this.insertSection = MenuUtils.addToMenu((ActionListener)this, this.popup, "SectionWidget.popup_insert_section", DEFAULT_POPUP_FONT);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if ("suppress".equals(string)) {
            this.editSuppression();
        } else if ("page_break".equals(string)) {
            this.togglePageBreak();
        } else if ("delete_group".equals(string)) {
            this.designer.deleteGroupContaining(this.section);
        } else if ("add_group".equals(string)) {
            this.designer.openNewGroupWin();
        } else if ("delete_section".equals(string)) {
            this.designer.deleteSection(this.section);
        } else if ("insert_section_below".equals(string)) {
            this.designer.insertSectionBelow(this.section);
        } else if ("shrink_to_fit".equals(string)) {
            this.shrinkToFit();
        }
    }

    protected void enablePopupMenuItems() {
        this.nameItem.setText(this.popupName);
        this.togglePageBreak.setSelected(this.section.hasPageBreak());
        this.deleteSection.setEnabled(!this.section.getReport().isOneOfAKind(this.section));
        this.deleteGroup.setEnabled(this.section.getReport().isInsideGroup(this.section));
    }

    protected void buildDisplayName() {
        this.label = new SectionNameLabel(this.name, this);
        this.add(this.label);
    }

    public void setDisplayName(String string) {
        this.name = string;
        this.label.setText(string);
    }

    public void setPopupName(String string) {
        this.popupName = string;
        this.nameItem.setText(string);
    }

    public Report getReport() {
        return this.section.getReport();
    }

    public Section getSection() {
        return this.section;
    }

    public SectionArea getSectionArea() {
        return this.section.getArea();
    }

    public Designer getDesigner() {
        return this.designer;
    }

    public int getPaperWidth() {
        return (int)this.section.getWidth();
    }

    public int getTotalWidth() {
        return 125 + this.getPaperWidth();
    }

    public int getHeight() {
        return (int)this.section.getMinHeight() + 6;
    }

    public int getSectionHeight() {
        return (int)this.section.getMinHeight();
    }

    public int getMinSectionHeight() {
        int n = 0;
        Component[] componentArray = this.fieldPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            int n2 = componentArray[i].getBounds().y + componentArray[i].getBounds().height;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    void paperSizeChanged() {
        this.setPreferredSize(new Dimension(this.getTotalWidth(), this.getHeight()));
        this.invalidate();
    }

    void editSuppression() {
        new SuppressionProcWin(this.designer, this);
    }

    void togglePageBreak() {
        this.performCommand(new SectionPageBreakCommand(this.section));
    }

    public void shrinkToFit() {
        SectionResizeCommand sectionResizeCommand = new SectionResizeCommand(this);
        this.growBy(this.getMinSectionHeight() - this.getSectionHeight());
        this.performCommand(sectionResizeCommand);
    }

    public void growToFit() {
        int n = this.getMinSectionHeight() - this.getSectionHeight();
        if (n > 0) {
            this.growBy(n);
        }
    }

    public void growBy(int n) {
        int n2;
        if (n == 0) {
            return;
        }
        int n3 = (int)this.section.getMinHeight();
        int n4 = n3 + n;
        if (n4 < (n2 = this.getMinSectionHeight()) && (n4 = n2) == n3) {
            return;
        }
        this.section.setMinHeight(n4);
        this.setPreferredSize(new Dimension(this.getTotalWidth(), this.getHeight()));
        this.revalidate();
    }

    public void resizeBy(int n, SectionResizeCommand sectionResizeCommand) {
        this.growBy(n);
        this.performCommand(sectionResizeCommand);
    }

    public void performCommand(Command command) {
        this.designer.performCommand(command);
    }

    public void setIgnoreKeys(boolean bl) {
        this.designer.setIgnoreKeys(bl);
    }

    public FieldWidget addTitleField(int n, int n2, String string) {
        return this.designer.addTitleField(n, n2, string);
    }

    void pickUp(Point point) {
        this.designer.pickUp(point);
    }

    void putDown(FieldWidget fieldWidget, Point point, Point point2) {
        this.designer.putDown(fieldWidget, point, point2);
    }

    void startStretching(Point point) {
        this.designer.startStretching(point);
    }

    void stopStretching(FieldWidget fieldWidget, Rectangle rectangle) {
        this.designer.stopStretching(fieldWidget, rectangle);
    }

    void dragSelectedWidgets(int n, Point point) {
        this.designer.dragSelectedWidgets(n, point);
    }

    void select(FieldWidget fieldWidget, boolean bl, boolean bl2) {
        this.designer.select(fieldWidget, bl, bl2);
    }

    void deselectAll() {
        this.designer.deselectAll();
    }

    public void addField(FieldWidget fieldWidget) {
        this.fieldPanel.add((Component)fieldWidget.getComponent(), 0);
        fieldWidget.sectionWidget = this;
        fieldWidget.getComponent().setBackground(this.section.isHidden() ? SUPPRESSED_COLOR : NORMAL_COLOR);
        this.growToFit();
    }

    public void removeField(FieldWidget fieldWidget) {
        this.fieldPanel.remove(fieldWidget.getComponent());
    }

    public SectionFieldPanel getFieldPanel() {
        return this.fieldPanel;
    }

    void snapToGrid(Rectangle rectangle) {
        this.designer.snapToGrid(rectangle);
    }

    void setFieldVisibility(boolean bl, FieldWidget fieldWidget) {
        this.designer.setFieldVisibility(bl, fieldWidget);
    }

    void createNewTextField(MouseEvent mouseEvent) {
        this.designer.createNewTextField(this, mouseEvent);
    }

    void showPopup(MouseEvent mouseEvent) {
        this.enablePopupMenuItems();
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SectionWidget.this.showPopup(mouseEvent);
            }
        }
    }
}

