/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.SectionResizeCommand;

class SectionResizer
extends JPanel
implements MouseInputListener {
    public static final int HEIGHT = 6;
    protected static final Color BEVEL_HILIGHT = new Color(221, 221, 221);
    protected static final Color SPLITTER_COLOR = new Color(153, 153, 153);
    protected static final Color BEVEL_SHADOW = new Color(102, 102, 102);
    protected static final Color GHOST_COLOR = new Color(153, 153, 255, 128);
    protected static boolean someoneDragging = false;
    protected SectionWidget target;
    protected Point start;
    protected int minY;
    protected Point mousePos;
    protected JPanel dragGhost;
    protected int localY;
    protected JLayeredPane parentWhileDragging;
    protected int parentWhileDraggingScreenY;
    protected SectionResizeCommand sectionResizeCommand;

    SectionResizer(SectionWidget sectionWidget, JLayeredPane jLayeredPane) {
        this.target = sectionWidget;
        this.parentWhileDragging = jLayeredPane;
        this.setBackground(SPLITTER_COLOR);
        this.setBorder(BorderFactory.createBevelBorder(0, BEVEL_HILIGHT, BEVEL_SHADOW));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!someoneDragging) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!someoneDragging) {
            this.setCursor(null);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.target.designer.isPlacingNewTextField()) {
            this.target.designer.rejectNewTextField();
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        this.localY = this.mousePos.y;
        Point point = this.getLocationOnScreen();
        this.mousePos.translate(point.x, point.y);
        this.setCursor(Cursor.getPredefinedCursor(12));
        someoneDragging = true;
        this.start = new Point(this.mousePos);
        this.parentWhileDraggingScreenY = this.parentWhileDragging.getLocationOnScreen().y;
        this.minY = this.target.getLocationOnScreen().y - this.parentWhileDraggingScreenY + this.target.getMinSectionHeight();
        this.dragGhost = new JPanel();
        this.dragGhost.setBackground(GHOST_COLOR);
        this.parentWhileDragging.add((Component)this.dragGhost, JLayeredPane.DRAG_LAYER);
        this.dragGhost.setBounds(0, this.start.y - this.localY - this.parentWhileDraggingScreenY, this.parentWhileDragging.getWidth(), 6);
        this.sectionResizeCommand = new SectionResizeCommand(this.target);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.getLocationOnScreen();
        point.translate(point2.x, point2.y);
        if (this.mousePos == null || point.y == this.mousePos.y) {
            return;
        }
        int n = point.y - this.localY - this.parentWhileDraggingScreenY;
        if (n < this.minY) {
            n = this.minY;
        }
        this.dragGhost.setLocation(0, n);
        this.mousePos = point;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        someoneDragging = false;
        Point point = mouseEvent.getPoint();
        Point point2 = this.getLocationOnScreen();
        point.translate(point2.x, point2.y);
        this.parentWhileDragging.remove(this.dragGhost);
        this.target.resizeBy(point.y - this.start.y - this.localY, this.sectionResizeCommand);
        this.parentWhileDragging.repaint();
    }
}

