/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;
import jimm.datavision.ErrorHandler;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.NewDraggedFieldCommand;

public class SectionFieldPanel
extends JPanel
implements DropTargetListener {
    protected SectionWidget sectionWidget;

    public SectionFieldPanel(SectionWidget sectionWidget) {
        this.sectionWidget = sectionWidget;
        new DropTarget(this, 3, this);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (dropTargetDropEvent.isDataFlavorSupported(dataFlavor)) {
                this.addField(dropTargetDropEvent, (String)transferable.getTransferData(dataFlavor));
                dropTargetDropEvent.acceptDrop(3);
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            ErrorHandler.error(exception);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    protected void addField(DropTargetDropEvent dropTargetDropEvent, String string) {
        this.sectionWidget.performCommand(new NewDraggedFieldCommand(this.sectionWidget, string, dropTargetDropEvent));
    }

    public void setHidden(boolean bl) {
        Color color = bl ? SectionWidget.SUPPRESSED_COLOR : SectionWidget.NORMAL_COLOR;
        this.setBackground(color);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setBackground(color);
        }
    }
}

