/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jimm.datavision.Scripting;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditFieldLayout;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.cmd.ScriptingCommand;
import jimm.util.I18N;

public class ScriptingWin
extends EditWin
implements ItemListener,
ActionListener,
DocumentListener {
    protected static final int LANG_NAME_COLS = 16;
    protected static final int CLASS_NAME_COLS = 40;
    protected Scripting scripting;
    protected JComboBox defaultLangMenu;
    protected JTextField langName;
    protected JTextField langClass;
    protected JButton addLangButton;
    protected JButton testLangButton;
    protected String defaultLang;
    protected Map languages;

    public ScriptingWin(Designer designer, Scripting scripting) {
        super(designer, I18N.get("ScriptingWin.title"), "ScriptingCommand.name");
        this.scripting = scripting;
        this.defaultLang = scripting.getDefaultLanguage();
        this.languages = new HashMap(scripting.getLanguages());
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        JPanel jPanel = this.buildEditor();
        JPanel jPanel2 = this.closeButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.fillEditFields();
    }

    protected JPanel buildEditor() {
        EditFieldLayout editFieldLayout = new EditFieldLayout();
        this.defaultLangMenu = editFieldLayout.addComboBox(I18N.get("ScriptingWin.default_lang"), this.langChoices());
        this.defaultLangMenu.addItemListener(this);
        editFieldLayout.skipRow();
        this.langName = editFieldLayout.addTextField(I18N.get("ScriptingWin.add_name"), "", 16);
        this.langClass = editFieldLayout.addTextField(I18N.get("ScriptingWin.add_class"), "", 40);
        this.langName.getDocument().addDocumentListener(this);
        this.langClass.getDocument().addDocumentListener(this);
        JPanel jPanel = new JPanel();
        this.addLangButton = new JButton(I18N.get("ScriptingWin.add_button"));
        this.testLangButton = new JButton(I18N.get("ScriptingWin.test_button"));
        jPanel.add(this.addLangButton);
        jPanel.add(this.testLangButton);
        editFieldLayout.add("", jPanel);
        this.addLangButton.addActionListener(this);
        this.testLangButton.addActionListener(this);
        return editFieldLayout.getPanel();
    }

    protected Object[] langChoices() {
        return this.languages.keySet().toArray();
    }

    protected void fillEditFields() {
        this.fillEditFields(this.defaultLang);
    }

    protected void fillEditFields(String string) {
        this.defaultLangMenu.setSelectedItem(string);
        this.langName.setText(string);
        this.langClass.setText((String)this.languages.get(string));
        this.enableButtons();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fillEditFields(itemEvent.getItem().toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("ScriptingWin.add_button").equals(string)) {
            this.addLanguage();
        } else if (I18N.get("ScriptingWin.test_button").equals(string)) {
            this.testLanguage();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void addLanguage() {
        String string = this.langName.getText().trim();
        String string2 = this.langClass.getText().trim();
        if (this.languages.get(string) == null) {
            this.defaultLangMenu.addItem(string);
        }
        this.languages.put(string, string2);
        this.fillEditFields();
    }

    protected void testLanguage() {
        int n;
        String string = this.langClass.getText().trim();
        String string2 = null;
        if (this.scripting.canFind(string)) {
            string2 = I18N.get("ScriptingWin.lang_ok");
            n = 1;
        } else {
            string2 = I18N.get("ScriptingWin.lang_err");
            n = 0;
        }
        JOptionPane.showMessageDialog(null, string2, I18N.get("ScriptingWin.title"), n);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    protected void enableButtons() {
        boolean bl = this.langName.getText().trim().length() > 0 && this.langClass.getText().trim().length() > 0;
        this.addLangButton.setEnabled(bl);
        this.testLangButton.setEnabled(bl);
    }

    protected void doSave() {
        this.defaultLang = (String)this.defaultLangMenu.getSelectedItem();
        ScriptingCommand scriptingCommand = new ScriptingCommand(this.scripting, this.defaultLang, this.languages);
        scriptingCommand.perform();
        this.commands.add(scriptingCommand);
    }

    protected void doRevert() {
        this.fillEditFields();
    }
}

