/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jimm.datavision.Group;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.cmd.NewGroupCommand;
import jimm.util.I18N;

class NewGroupWin
extends JDialog
implements ActionListener {
    protected Designer designer;
    protected Report report;
    protected JComboBox combo;
    protected JRadioButton ascendingButton;
    protected JRadioButton descendingButton;

    public NewGroupWin(Designer designer, Report report) {
        super(designer.getFrame(), I18N.get("NewGroupWin.title"));
        this.designer = designer;
        this.report = report;
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        JPanel jPanel = this.buildGuts();
        JPanel jPanel2 = this.buildButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
    }

    protected JPanel buildGuts() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel jLabel = new JLabel(I18N.get("NewGroupWin.group_column"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = this.buildColumnComboBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jLabel = new JLabel(I18N.get("NewGroupWin.sort_order"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        Box box = this.buildSortOrderRadioButtons();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        jPanel.add(box);
        return jPanel;
    }

    protected JPanel buildColumnComboBox() {
        Object object;
        DefaultComboBoxModel<Selectable> defaultComboBoxModel = new DefaultComboBoxModel<Selectable>();
        Iterator iterator = this.report.userColumns();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement((Selectable)iterator.next());
        }
        iterator = this.report.getDataSource().columnsInTablesUsedInReport();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement((Selectable)iterator.next());
        }
        iterator = this.report.groups();
        while (iterator.hasNext()) {
            object = (Group)iterator.next();
            defaultComboBoxModel.removeElement(((Group)object).getSelectable());
        }
        this.combo = new JComboBox(defaultComboBoxModel);
        this.combo.setSelectedIndex(0);
        object = new JPanel();
        ((Container)object).add(this.combo);
        return object;
    }

    protected Box buildSortOrderRadioButtons() {
        Box box = Box.createVerticalBox();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ascendingButton = new JRadioButton(I18N.get("GUI.ascending"));
        this.ascendingButton.addActionListener(this);
        box.add(this.ascendingButton);
        buttonGroup.add(this.ascendingButton);
        this.descendingButton = new JRadioButton(I18N.get("GUI.descending"));
        this.descendingButton.addActionListener(this);
        box.add(this.descendingButton);
        buttonGroup.add(this.descendingButton);
        this.ascendingButton.setSelected(true);
        return box;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("GUI.ok"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        jButton = new JButton(I18N.get("GUI.cancel"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("GUI.ok").equals(string)) {
            int n = this.ascendingButton.isSelected() ? 0 : 1;
            NewGroupCommand newGroupCommand = new NewGroupCommand(this.designer, this.report, (Selectable)this.combo.getSelectedItem(), n);
            this.designer.performCommand(newGroupCommand);
            this.dispose();
        } else if (I18N.get("GUI.cancel").equals(string)) {
            this.dispose();
        }
    }
}

