/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import jimm.datavision.PaperFormat;
import jimm.util.I18N;
import jimm.util.StringUtils;

public class MenuUtils {
    public static JMenu readMenu(String string) {
        JMenu jMenu = new JMenu(I18N.get("menu", string));
        MenuUtils.setKeys(jMenu, string);
        return jMenu;
    }

    public static JMenuItem readItem(ActionListener actionListener, String string, Font font) {
        JMenuItem jMenuItem = new JMenuItem(I18N.get("menu", string));
        MenuUtils.modifyItem(jMenuItem, actionListener, string, font);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem readCheckboxItem(ActionListener actionListener, String string, Font font) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18N.get("menu", string));
        MenuUtils.modifyItem(jCheckBoxMenuItem, actionListener, string, font);
        return jCheckBoxMenuItem;
    }

    protected static void modifyItem(JMenuItem jMenuItem, ActionListener actionListener, String string, Font font) {
        String string2;
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        if (font != null) {
            jMenuItem.setFont(font);
        }
        if ((string2 = I18N.getNullIfMissing("menu", string + ".action")) != null && string2.length() > 0) {
            jMenuItem.setActionCommand(string2);
        }
        if ((string2 = I18N.getNullIfMissing("menu", string + ".enabled")) != null && string2.length() > 0 && ("false".equalsIgnoreCase(string2) || "no".equalsIgnoreCase(string2))) {
            jMenuItem.setEnabled(false);
        }
        MenuUtils.setKeys(jMenuItem, string);
    }

    public static JMenuItem addToMenu(ActionListener actionListener, JMenu jMenu, String string) {
        return MenuUtils.addToMenu(actionListener, jMenu, string, null);
    }

    public static JMenuItem addToMenu(ActionListener actionListener, JMenu jMenu, String string, Font font) {
        JMenuItem jMenuItem = MenuUtils.readItem(actionListener, string, font);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    public static JMenuItem addToMenu(ActionListener actionListener, JPopupMenu jPopupMenu, String string) {
        return MenuUtils.addToMenu(actionListener, jPopupMenu, string, null);
    }

    public static JMenuItem addToMenu(ActionListener actionListener, JPopupMenu jPopupMenu, String string, Font font) {
        JMenuItem jMenuItem = MenuUtils.readItem(actionListener, string, font);
        jPopupMenu.add(jMenuItem);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem addCheckboxToMenu(ActionListener actionListener, JMenu jMenu, String string, Font font) {
        JCheckBoxMenuItem jCheckBoxMenuItem = MenuUtils.readCheckboxItem(actionListener, string, font);
        jMenu.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    public static JCheckBoxMenuItem addCheckboxToMenu(ActionListener actionListener, JPopupMenu jPopupMenu, String string, Font font) {
        JCheckBoxMenuItem jCheckBoxMenuItem = MenuUtils.readCheckboxItem(actionListener, string, font);
        jPopupMenu.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    public static JMenuItem addToMenu(JMenu jMenu, Action action, String string) {
        JMenuItem jMenuItem = jMenu.add(action);
        MenuUtils.setKeys(jMenuItem, string);
        return jMenuItem;
    }

    protected static void setKeys(JMenuItem jMenuItem, String string) {
        String string2 = I18N.getNullIfMissing("menu", string + ".keys");
        if (string2 == null) {
            return;
        }
        List list = StringUtils.split(string2, " ");
        if (list.size() >= 1) {
            string = (String)list.get(0);
            jMenuItem.setMnemonic((int)string.charAt(0));
        }
        if (list.size() >= 2) {
            string = (String)list.get(1);
            int n = string.charAt(0);
            int n2 = 2;
            if ("DEL".equals(string)) {
                n = 127;
                n2 = 0;
            }
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        }
    }

    public static JMenu buildAlignMenu(ActionListener actionListener, Font font) {
        JMenu jMenu = MenuUtils.readMenu("Align.menu");
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_tops", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_middles", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_bottoms", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_lefts", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_centers", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_rights", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Align.menu_snap", font);
        return jMenu;
    }

    public static JMenu buildSizeMenu(ActionListener actionListener, Font font) {
        JMenu jMenu = MenuUtils.readMenu("Size.menu");
        MenuUtils.addToMenu(actionListener, jMenu, "Size.menu_same_width", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Size.menu_same_height", font);
        MenuUtils.addToMenu(actionListener, jMenu, "Size.menu_same_size", font);
        return jMenu;
    }

    public static JMenu buildPaperSizeMenu(ActionListener actionListener, PaperFormat paperFormat, ButtonGroup buttonGroup, ButtonGroup buttonGroup2) {
        JMenu jMenu = MenuUtils.readMenu("MenuUtils.menu_paper_size");
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        String string = "MenuUtils.menu_paper_size_portrait";
        String string2 = I18N.get("menu", string);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
        String string3 = I18N.getNullIfMissing("menu", string + ".action");
        if (string3 != null && string3.length() > 0) {
            jRadioButtonMenuItem.setActionCommand(string3);
        }
        buttonGroup.add(jRadioButtonMenuItem);
        if (actionListener != null) {
            jRadioButtonMenuItem.addActionListener(actionListener);
        }
        if (paperFormat.getOrientation() == 0) {
            jRadioButtonMenuItem.setSelected(true);
        }
        jMenu.add(jRadioButtonMenuItem);
        string = "MenuUtils.menu_paper_size_landscape";
        string2 = I18N.get("menu", string);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
        string3 = I18N.getNullIfMissing("menu", string + ".action");
        if (string3 != null && string3.length() > 0) {
            jRadioButtonMenuItem.setActionCommand(string3);
        }
        buttonGroup.add(jRadioButtonMenuItem);
        if (actionListener != null) {
            jRadioButtonMenuItem.addActionListener(actionListener);
        }
        if (paperFormat.getOrientation() == 1) {
            jRadioButtonMenuItem.setSelected(true);
        }
        jMenu.add(jRadioButtonMenuItem);
        jMenu.addSeparator();
        Iterator iterator = PaperFormat.names();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(string4);
            buttonGroup2.add(jRadioButtonMenuItem);
            if (actionListener != null) {
                jRadioButtonMenuItem.addActionListener(actionListener);
            }
            if (string4.equals(paperFormat.getName())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }
}

