/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jimm.datavision.ErrorHandler;
import jimm.datavision.gui.HelpURLStack;
import jimm.util.I18N;

public class HelpWin
extends JFrame
implements HyperlinkListener {
    protected static final int START_WIDTH = 400;
    protected static final int START_HEIGHT = 500;
    protected static final String DOCS_DIR = "docs";
    protected static final String HTML_DIR = "DataVision";
    protected static final String START_CONTENT_FILE = "DataVision.html";
    protected static final String HOME_ICON = "images/Home16.gif";
    protected static final String PREV_ICON = "images/Back16.gif";
    protected static final String NEXT_ICON = "images/Forward16.gif";
    protected static HelpWin helpWin;
    protected JEditorPane contentEditorPane;
    protected HelpURLStack pages;
    protected Action goHomeAction;
    protected Action goPrevAction;
    protected Action goNextAction;
    protected JTextField urlField;

    public static synchronized HelpWin instance() {
        if (helpWin == null) {
            helpWin = new HelpWin();
        }
        return helpWin;
    }

    protected HelpWin() {
        super(I18N.get("HelpWin.title"));
        this.buildWindow();
        this.pages = new HelpURLStack(this.contentEditorPane, this.urlField);
        this.pack();
        this.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                HelpWin.this.loadHelp();
            }
        }).start();
    }

    protected void buildWindow() {
        this.makeActions();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.makeToolbar(), "North");
        this.getContentPane().add((Component)this.buildContentPane(), "Center");
    }

    protected JComponent buildContentPane() {
        this.contentEditorPane = new JEditorPane();
        this.contentEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.contentEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(400, 500));
        this.contentEditorPane.addHyperlinkListener(this);
        return jScrollPane;
    }

    protected void makeActions() {
        URL uRL = this.getClass().getClassLoader().getResource(HOME_ICON);
        String string = I18N.get("HelpWin.cmd_home");
        this.goHomeAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWin.this.pages.goToHomePage();
                HelpWin.this.updateNavActions();
            }
        };
        this.goHomeAction.putValue("ShortDescription", string);
        this.goHomeAction.setEnabled(true);
        uRL = this.getClass().getClassLoader().getResource(PREV_ICON);
        string = I18N.get("HelpWin.cmd_prev");
        this.goPrevAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWin.this.pages.goToPreviousPage();
                HelpWin.this.updateNavActions();
            }
        };
        this.goPrevAction.putValue("ShortDescription", string);
        this.goPrevAction.setEnabled(false);
        uRL = this.getClass().getClassLoader().getResource(NEXT_ICON);
        string = I18N.get("HelpWin.cmd_next");
        this.goNextAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWin.this.pages.goToNextPage();
                HelpWin.this.updateNavActions();
            }
        };
        this.goNextAction.putValue("ShortDescription", string);
        this.goNextAction.setEnabled(false);
    }

    protected JToolBar makeToolbar() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.add(this.goHomeAction);
        jToolBar.add(this.goPrevAction);
        jToolBar.add(this.goNextAction);
        this.urlField = new JTextField(40);
        this.urlField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWin.this.pages.goTo(HelpWin.this.urlField.getText());
            }
        });
        jToolBar.add(this.urlField);
        return jToolBar;
    }

    protected void updateNavActions() {
        this.goPrevAction.setEnabled(this.pages.hasPrevious());
        this.goNextAction.setEnabled(this.pages.hasNext());
    }

    protected void loadHelp() {
        String string = null;
        URL uRL = null;
        try {
            String string2 = System.getProperty("file.separator");
            string = "file:" + System.getProperty("user.dir") + string2 + DOCS_DIR + string2 + HTML_DIR + string2 + START_CONTENT_FILE;
            uRL = new URL(string);
        }
        catch (Exception exception) {
            ErrorHandler.error(I18N.get("HelpWin.error") + ' ' + string, exception);
        }
        if (uRL != null) {
            this.pages.goTo(uRL);
            this.updateNavActions();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
            HTMLDocument hTMLDocument = (HTMLDocument)this.contentEditorPane.getDocument();
            hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
        } else {
            try {
                this.pages.goTo(hyperlinkEvent.getURL());
                this.updateNavActions();
            }
            catch (Throwable throwable) {
                ErrorHandler.error(throwable);
            }
        }
    }
}

