/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import jimm.datavision.ErrorHandler;
import jimm.util.I18N;

class HelpURLStack {
    protected Stack back;
    protected URL home;
    protected URL current;
    protected Stack forward;
    protected JEditorPane contentField;
    protected JTextField urlField;

    HelpURLStack(JEditorPane jEditorPane, JTextField jTextField) {
        this.contentField = jEditorPane;
        this.urlField = jTextField;
        this.back = new Stack();
        this.current = null;
        this.forward = new Stack();
    }

    boolean hasPrevious() {
        return !this.back.empty();
    }

    boolean hasNext() {
        return !this.forward.empty();
    }

    void goTo(String string) {
        try {
            URL uRL = new URL(string);
            this.goTo(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorHandler.error(I18N.get("HelpURLStack.error_parsing") + ' ' + string, malformedURLException);
        }
    }

    void goTo(URL uRL) {
        if (this.current != null) {
            this.back.push(this.current);
        }
        if (this.home == null) {
            this.home = uRL;
        }
        this.current = uRL;
        this.forward.clear();
        this.updateGUI();
    }

    void goToHomePage() {
        this.goTo(this.home);
    }

    void goToPreviousPage() {
        if (this.hasPrevious()) {
            if (this.current != null) {
                this.forward.push(this.current);
            }
            this.current = (URL)this.back.pop();
        }
        this.updateGUI();
    }

    void goToNextPage() {
        if (this.hasNext()) {
            if (this.current != null) {
                this.back.push(this.current);
            }
            this.current = (URL)this.forward.pop();
        }
        this.updateGUI();
    }

    protected void updateGUI() {
        this.urlField.setText(this.current == null ? "" : this.current.toString());
        try {
            this.contentField.setPage(this.current);
        }
        catch (IOException iOException) {
            ErrorHandler.error(I18N.get("HelpURLStack.error_loading") + ' ' + this.current, iOException);
        }
    }
}

