/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import jimm.datavision.Group;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.GroupWinListItem;
import jimm.datavision.gui.TwoListWin;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.GroupEditCommand;
import jimm.util.I18N;

public class GroupWin
extends TwoListWin {
    public GroupWin(Designer designer, Report report) {
        super(designer, I18N.get("GroupWin.title"), "GroupChangeCommand.name", "GroupWin.right_box_title", report);
    }

    protected void fillListModels() {
        Iterator iterator = this.report.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            this.rightModel.addElement(new GroupWinListItem(group.getSelectable(), group));
        }
        iterator = this.report.userColumns();
        while (iterator.hasNext()) {
            this.addToModel((Selectable)iterator.next());
        }
        iterator = this.report.getDataSource().columnsInTablesUsedInReport();
        while (iterator.hasNext()) {
            this.addToModel((Selectable)iterator.next());
        }
    }

    protected void addToModel(Selectable selectable) {
        Group group = this.report.findGroup(selectable);
        if (group == null) {
            this.leftModel.add(new GroupWinListItem(selectable, group));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(I18N.get("GUI.ascending"))) {
            ((GroupWinListItem)this.rightList.getSelectedValue()).sortOrder = 0;
        } else if (string.equals(I18N.get("GUI.descending"))) {
            ((GroupWinListItem)this.rightList.getSelectedValue()).sortOrder = 1;
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void doSave() {
        ArrayList arrayList = new ArrayList();
        Object object = this.rightModel.elements();
        while (object.hasMoreElements()) {
            arrayList.add(object.nextElement());
        }
        object = new GroupEditCommand(this.report, this.designer, arrayList);
        ((GroupEditCommand)object).perform();
        this.commands.add((Command)object);
    }

    protected void doRevert() {
        this.leftModel.removeAllElements();
        this.rightModel.removeAllElements();
        this.fillListModels();
        this.adjustButtons();
    }
}

