/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Formula;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.ScriptEditorWin;
import jimm.datavision.gui.cmd.FormulaEditCommand;
import jimm.util.I18N;

public class FormulaWin
extends ScriptEditorWin
implements Observer {
    protected Formula formula;

    public FormulaWin(Designer designer, Report report, Formula formula) {
        super(designer, report, formula.getEditableExpression(), I18N.get("FormulaWin.title_prefix") + ' ' + formula.getName(), "FormulaWin.error_unchanged", "FormulaWin.error_title");
        this.formula = formula;
        formula.addObserver(this);
        this.setLanguage(formula.getLanguage());
    }

    protected void finalize() throws Throwable {
        this.formula.deleteObserver(this);
        super.finalize();
    }

    public void update(Observable observable, Object object) {
        this.setTitle(I18N.get("FormulaWin.title_prefix") + ' ' + this.formula.getName());
        this.codeField.setText(this.formula.getEditableExpression());
    }

    public void save(String string) {
        this.formula.deleteObserver(this);
        this.command = new FormulaEditCommand(this.formula, string, this.getLanguage());
    }
}

