/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jimm.datavision.FieldWalker;
import jimm.datavision.field.Border;
import jimm.datavision.field.BorderEdge;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditFieldLayout;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.cmd.FormatCommand;
import jimm.util.I18N;

public class FormatWin
extends EditWin
implements FieldWalker {
    protected static Integer[] SIZE_CHOICES;
    protected static final int FORMAT_TEXT_FIELD_COLS = 20;
    protected static final int THICKNESS_COLS = 8;
    protected static final int TOP = 0;
    protected static final int LEFT = 1;
    protected static final int RIGHT = 2;
    protected static final int BOTTOM = 3;
    protected static String[] fontFamilyNames;
    protected Field field;
    protected Format format;
    protected Border border;
    protected Format origFormat;
    protected Border origBorder;
    protected boolean saveRevertInfo;
    protected JComboBox fontFamily;
    protected JComboBox size;
    protected JCheckBox bold;
    protected JCheckBox italic;
    protected JCheckBox underline;
    protected JCheckBox wrap;
    protected JComboBox align;
    protected JTextField formatText;
    protected JLabel fieldColorLabel;
    protected JLabel borderColorLabel;
    protected EdgeWidgets[] edgeWidgets;

    public static void loadFontChoices() {
        if (fontFamilyNames == null) {
            new Thread(new Runnable(){

                public void run() {
                    fontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                }
            }).start();
        }
    }

    public FormatWin(Designer designer, Field field, int n) {
        super(designer, I18N.get("FormatWin.title") + (field.designLabel().startsWith("{") ? " " : " (") + field.designLabel() + (designer.countSelectedFields() > 1 ? " +" : "") + (field.designLabel().startsWith("{") ? " " : " )"), "FormatCommand.name");
        this.field = field;
        this.origFormat = this.field.getFormat();
        if (this.origFormat != null) {
            this.origFormat = (Format)this.origFormat.clone();
        }
        this.origBorder = this.field.getBorder();
        if (this.origBorder != null) {
            this.origBorder = (Border)this.origBorder.clone();
        }
        this.copyFormatAndBorder(this.field.getFormat(), this.field.getBorder());
        this.buildWindow(n);
        this.pack();
        this.setVisible(true);
    }

    protected void copyFormatAndBorder(Format format, Border border) {
        this.format = (Format)format.clone();
        if (border == null) {
            this.border = (Border)this.field.getReport().getDefaultField().getBorder().clone();
            this.border.setField(this.field);
        } else {
            this.border = (Border)border.clone();
        }
        if (this.border.getTop() == null) {
            this.border.setTop(new BorderEdge(0, 1.0, 0));
        }
        if (this.border.getBottom() == null) {
            this.border.setBottom(new BorderEdge(0, 1.0, 0));
        }
        if (this.border.getLeft() == null) {
            this.border.setLeft(new BorderEdge(0, 1.0, 0));
        }
        if (this.border.getRight() == null) {
            this.border.setRight(new BorderEdge(0, 1.0, 0));
        }
    }

    protected void buildWindow(int n) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(I18N.get("FormatWin.format_tab"), this.buildFormatTab());
        jTabbedPane.addTab(I18N.get("FormatWin.border_tab"), this.buildBorderTab());
        jTabbedPane.setSelectedIndex(n);
        JPanel jPanel = this.closeButtonPanel();
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.fillFormatTab();
        this.fillBorderTab();
    }

    protected Container buildFormatTab() {
        EditFieldLayout editFieldLayout = new EditFieldLayout();
        this.fontFamily = editFieldLayout.addComboBox(I18N.get("FormatWin.font"), this.fontChoices(), true);
        this.size = editFieldLayout.addComboBox(I18N.get("FormatWin.size"), this.sizeChoices(), true);
        this.bold = editFieldLayout.addCheckBox(I18N.get("FormatWin.bold"), 66);
        this.italic = editFieldLayout.addCheckBox(I18N.get("FormatWin.italic"), 73);
        this.underline = editFieldLayout.addCheckBox(I18N.get("FormatWin.underline"), 85);
        this.wrap = editFieldLayout.addCheckBox(I18N.get("FormatWin.wrap"), 87);
        this.align = editFieldLayout.addComboBox(I18N.get("FormatWin.align"), this.alignChoices());
        this.formatText = editFieldLayout.addTextField(I18N.get("FormatWin.format"), 20);
        editFieldLayout.add(I18N.get("FormatWin.color"), this.buildFieldColorWidgets());
        Box box = Box.createVerticalBox();
        box.add(Box.createGlue());
        box.add(editFieldLayout.getPanel());
        box.add(Box.createGlue());
        return box;
    }

    protected Box buildFieldColorWidgets() {
        Box box = Box.createHorizontalBox();
        this.fieldColorLabel = new JLabel(I18N.get("FormatWin.sample_text"));
        box.add(this.fieldColorLabel);
        this.setFieldExampleColor();
        box.add(Box.createHorizontalStrut(16));
        box.add(this.createFieldColorChooserButton());
        return box;
    }

    protected Box buildBorderColorWidgets() {
        Box box = Box.createHorizontalBox();
        this.borderColorLabel = new JLabel(I18N.get("FormatWin.sample_text"));
        box.add(this.borderColorLabel);
        this.setBorderExampleColor();
        box.add(Box.createHorizontalStrut(16));
        box.add(this.createBorderColorChooserButton());
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalGlue());
        box2.add(new JLabel(I18N.get("FormatWin.color")));
        box2.add(Box.createVerticalStrut(6));
        box2.add(box);
        box2.add(Box.createVerticalGlue());
        return box2;
    }

    protected void setFieldExampleColor() {
        this.fieldColorLabel.setForeground(this.format.getColor());
    }

    protected void setBorderExampleColor() {
        this.borderColorLabel.setForeground(this.border.getColor());
    }

    protected JButton createFieldColorChooserButton() {
        JButton jButton = new JButton(I18N.get("FormatWin.choose"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(FormatWin.this, I18N.get("FormatWin.field_color_title"), FormatWin.this.format.getColor());
                if (color != null) {
                    FormatWin.this.format.setColor(color);
                    FormatWin.this.setFieldExampleColor();
                }
            }
        });
        return jButton;
    }

    protected JButton createBorderColorChooserButton() {
        JButton jButton = new JButton(I18N.get("FormatWin.choose"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(FormatWin.this, I18N.get("FormatWin.border_color_title"), FormatWin.this.border.getColor());
                if (color != null) {
                    FormatWin.this.border.setColor(color);
                    FormatWin.this.setBorderExampleColor();
                }
            }
        });
        return jButton;
    }

    protected Integer[] sizeChoices() {
        if (SIZE_CHOICES == null) {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 6; n <= 12; ++n) {
                arrayList.add(new Integer(n));
            }
            for (n = 14; n <= 36; n += 2) {
                arrayList.add(new Integer(n));
            }
            SIZE_CHOICES = new Integer[arrayList.size()];
            arrayList.toArray(SIZE_CHOICES);
        }
        return SIZE_CHOICES;
    }

    protected int sizeIndexOf(int n) {
        Integer[] integerArray = this.sizeChoices();
        for (int i = 0; i < integerArray.length; ++i) {
            if (integerArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    protected String[] fontChoices() {
        return fontFamilyNames;
    }

    protected int fontIndexOf(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        String[] stringArray = this.fontChoices();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected String[] alignChoices() {
        String[] stringArray = new String[3];
        int n = 0;
        stringArray[n++] = I18N.get("FormatWin.align_left");
        stringArray[n++] = I18N.get("FormatWin.align_center");
        stringArray[n++] = I18N.get("FormatWin.align_right");
        return stringArray;
    }

    protected String[] edgeCountChoices() {
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = I18N.get("FormatWin.edge_count_" + i);
        }
        return stringArray;
    }

    protected String[] edgeStyleChoices() {
        String[] stringArray = new String[3];
        int n = 0;
        stringArray[n++] = I18N.get("FormatWin.edge_style_line");
        stringArray[n++] = I18N.get("FormatWin.edge_style_dashed");
        stringArray[n++] = I18N.get("FormatWin.edge_style_dotted");
        return stringArray;
    }

    protected Box buildBorderTab() {
        this.edgeWidgets = new EdgeWidgets[4];
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(this.buildBorderEdge(0, I18N.get("FormatWin.edge_top"), this.border.getTop()));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(this.buildBorderEdge(1, I18N.get("FormatWin.edge_left"), this.border.getLeft()));
        box2.add(this.buildBorderColorWidgets());
        box2.add(this.buildBorderEdge(2, I18N.get("FormatWin.edge_right"), this.border.getRight()));
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(this.buildBorderEdge(3, I18N.get("FormatWin.edge_bottom"), this.border.getBottom()));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        return box;
    }

    protected Box buildBorderEdge(int n, String string, final BorderEdge borderEdge) {
        EdgeWidgets edgeWidgets;
        this.edgeWidgets[n] = edgeWidgets = new EdgeWidgets(borderEdge, string);
        EditFieldLayout editFieldLayout = new EditFieldLayout();
        edgeWidgets.numberComboBox = editFieldLayout.addComboBox(I18N.get("FormatWin.count"), this.edgeCountChoices());
        edgeWidgets.styleComboBox = editFieldLayout.addComboBox(I18N.get("FormatWin.style"), this.edgeStyleChoices());
        edgeWidgets.thicknessText = editFieldLayout.addTextField(I18N.get("FormatWin.thickness"), 8);
        final JComboBox jComboBox = edgeWidgets.numberComboBox;
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getSelectedItem();
                String[] stringArray = FormatWin.this.edgeCountChoices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    borderEdge.setNumber(i);
                    break;
                }
            }
        });
        final JComboBox jComboBox2 = edgeWidgets.styleComboBox;
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox2.getSelectedItem();
                String[] stringArray = FormatWin.this.edgeStyleChoices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    borderEdge.setStyle(i);
                    break;
                }
            }
        });
        Box box = Box.createVerticalBox();
        box.add(new JLabel(edgeWidgets.getName()));
        box.add(Box.createVerticalStrut(8));
        box.add(editFieldLayout.getPanel());
        return box;
    }

    protected void fillFormatTab() {
        int n;
        String string = this.format.getFontFamilyName();
        if (string == null) {
            string = "";
        }
        if ((n = this.fontIndexOf(string)) == -1) {
            this.fontFamily.setSelectedItem(null);
            this.fontFamily.configureEditor(this.fontFamily.getEditor(), string);
        } else {
            this.fontFamily.setSelectedIndex(n);
        }
        int n2 = (int)this.format.getSize();
        n = this.sizeIndexOf(n2);
        if (n == -1) {
            this.size.setSelectedItem(null);
            this.size.configureEditor(this.size.getEditor(), "" + n2);
        } else {
            this.size.setSelectedIndex(n);
        }
        this.bold.setSelected(this.format.isBold());
        this.italic.setSelected(this.format.isItalic());
        this.underline.setSelected(this.format.isUnderline());
        this.wrap.setSelected(this.format.isWrap());
        this.align.setSelectedIndex(this.format.getAlign());
        this.formatText.setText(this.format.getFormat());
    }

    protected void fillBorderTab() {
        for (int i = 0; i < 4; ++i) {
            EdgeWidgets edgeWidgets = this.edgeWidgets[i];
            edgeWidgets.numberComboBox.setSelectedIndex(edgeWidgets.edge.getNumber());
            edgeWidgets.styleComboBox.setSelectedIndex(edgeWidgets.edge.getStyle());
            edgeWidgets.thicknessText.setText("" + edgeWidgets.edge.getThickness());
        }
    }

    protected void doSave() {
        Object object = this.fontFamily.getSelectedItem();
        if (object == null || object.toString().length() == 0) {
            this.format.setFontFamilyName(null);
        } else {
            this.format.setFontFamilyName(object.toString());
        }
        double d = Double.parseDouble(this.size.getSelectedItem().toString());
        this.format.setSize(d);
        this.format.setBold(this.bold.isSelected());
        this.format.setItalic(this.italic.isSelected());
        this.format.setUnderline(this.underline.isSelected());
        this.format.setWrap(this.wrap.isSelected());
        String string = (String)this.align.getSelectedItem();
        if (string.equals(I18N.get("FormatWin.align_left"))) {
            this.format.setAlign(0);
        } else if (string.equals(I18N.get("FormatWin.align_center"))) {
            this.format.setAlign(1);
        } else {
            this.format.setAlign(2);
        }
        this.format.setFormat(this.formatText.getText());
        for (int i = 0; i < 4; ++i) {
            EdgeWidgets edgeWidgets = this.edgeWidgets[i];
            edgeWidgets.edge.setThickness(Double.parseDouble(edgeWidgets.thicknessText.getText()));
        }
        if (this.designer.countSelectedFields() == 0 || this.field == this.field.getReport().getDefaultField()) {
            this.step(this.field);
        } else {
            this.designer.withSelectedFieldsDo(this);
        }
    }

    public void step(Field field) {
        FormatCommand formatCommand = new FormatCommand(field, this.format, this.border);
        formatCommand.perform();
        this.commands.add(formatCommand);
    }

    protected void doRevert() {
        this.fillFormatTab();
        this.fillBorderTab();
    }

    static class EdgeWidgets {
        protected BorderEdge edge;
        protected String name;
        protected JComboBox numberComboBox;
        protected JComboBox styleComboBox;
        protected JTextField thicknessText;

        EdgeWidgets(BorderEdge borderEdge, String string) {
            this.edge = borderEdge;
            this.name = string;
        }

        String getName() {
            return this.name;
        }
    }
}

