/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.MouseInputListener;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.gui.AggregatesWin;
import jimm.datavision.gui.BoundsWin;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FWBorder;
import jimm.datavision.gui.FormatWin;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.PreMoveInfo;
import jimm.datavision.gui.PreStretchInfo;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.layout.swing.AbstractSwingField;
import jimm.datavision.layout.swing.SwingTextField;
import jimm.util.I18N;

public class FieldWidget
implements MouseInputListener,
DropTargetListener,
ActionListener,
KeyListener,
Observer {
    protected static final int GRAB_EDGE_WIDTH = 4;
    protected static final int ACTION_INACTION = 0;
    protected static final int ACTION_MOVE = 1;
    protected static final int ACTION_STRETCH_LEFT = 2;
    protected static final int ACTION_STRETCH_RIGHT = 3;
    protected static final int ACTION_STRETCH_TOP = 4;
    protected static final int ACTION_STRETCH_BOTTOM = 5;
    protected static final int ACTION_POPPING_UP_MENU = 6;
    protected static final int MIN_SIZE = 2;
    protected static final Font POPUP_FONT = new Font("Serif", 0, 10);
    protected static HashMap componentMap = new HashMap();
    protected AbstractSwingField swingField;
    protected SectionWidget sectionWidget;
    protected int action;
    protected boolean actionStartedYet;
    protected boolean selected;
    protected boolean mouseChangedSelectedState;
    protected PreMoveInfo preMoveInfo;
    protected PreStretchInfo preStretchInfo;
    protected JPopupMenu popup;
    protected JMenu alignSubmenu;
    protected JMenu sizeSubmenu;
    protected JMenuItem nameItem;
    protected JMenuItem showOrHide;
    protected JMenuItem formatMenuItem;
    protected JMenuItem aggregatesMenuItem;

    static FieldWidget findFieldWidgetOwning(Object object) {
        return (FieldWidget)componentMap.get(object);
    }

    public FieldWidget(SectionWidget sectionWidget, Field field) {
        this(sectionWidget, new SwingTextField(field, field.designLabel()));
    }

    protected FieldWidget(SectionWidget sectionWidget, AbstractSwingField abstractSwingField) {
        this.sectionWidget = sectionWidget;
        this.swingField = abstractSwingField;
        this.action = 0;
        jimm.datavision.field.Rectangle rectangle = this.getField().getBounds();
        this.getComponent().setBounds((int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height);
        this.getComponent().setBorder(new FWBorder(this));
        this.getComponent().addMouseListener(this);
        this.getComponent().addMouseMotionListener(this);
        this.getComponent().addKeyListener(this);
        this.buildPopupMenu();
        new DropTarget(this.getComponent(), 3, this);
        this.setVisibilityLook();
        this.getField().addObserver(this);
        componentMap.put(this.getComponent(), this);
    }

    protected void buildPopupMenu() {
        this.popup = new JPopupMenu();
        this.popup.setFont(POPUP_FONT);
        this.nameItem = MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_dummy_title", POPUP_FONT);
        this.nameItem.setText(this.getPopupNameText());
        this.nameItem.setEnabled(false);
        this.popup.addSeparator();
        this.addCustomPopupItems();
        this.showOrHide = MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_hide", POPUP_FONT);
        MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_delete", POPUP_FONT);
        this.popup.addSeparator();
        this.formatMenuItem = MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_format", POPUP_FONT);
        MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_border", POPUP_FONT);
        MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_bounds", POPUP_FONT);
        this.popup.addSeparator();
        this.aggregatesMenuItem = MenuUtils.addToMenu((ActionListener)this, this.popup, "FieldWidget.popup_aggr", POPUP_FONT);
        this.popup.addSeparator();
        this.alignSubmenu = MenuUtils.buildAlignMenu(this, POPUP_FONT);
        this.alignSubmenu.setFont(POPUP_FONT);
        this.popup.add(this.alignSubmenu);
        this.sizeSubmenu = MenuUtils.buildSizeMenu(this, POPUP_FONT);
        this.sizeSubmenu.setFont(POPUP_FONT);
        this.popup.add(this.sizeSubmenu);
    }

    protected void addCustomPopupItems() {
    }

    protected void finalize() throws Throwable {
        this.getField().deleteObserver(this);
    }

    public void update(Observable observable, Object object) {
        double d;
        this.swingField.format();
        jimm.datavision.field.Rectangle rectangle = this.getField().getBounds();
        JTextPane jTextPane = (JTextPane)this.getComponent();
        double d2 = rectangle.width;
        if (d2 < 2.0) {
            d2 = 2.0;
        }
        if ((d = rectangle.height) < 2.0) {
            d = 2.0;
        }
        jTextPane.setBounds((int)rectangle.x, (int)rectangle.y, (int)d2, (int)d);
        jTextPane.setText(this.getField().designLabel());
    }

    public boolean usesFormat() {
        return true;
    }

    protected String getPopupNameText() {
        return this.getField().designLabel();
    }

    public SectionWidget getSectionWidget() {
        return this.sectionWidget;
    }

    boolean isSelected() {
        return this.selected;
    }

    public void align(int n, Field field) {
        jimm.datavision.field.Rectangle rectangle = this.getField().getBounds();
        jimm.datavision.field.Rectangle rectangle2 = field.getBounds();
        switch (n) {
            case 0: {
                rectangle.setY(rectangle2.y);
                break;
            }
            case 1: {
                double d = rectangle2.y + rectangle2.height / 2.0;
                rectangle.setY(d - rectangle.height / 2.0);
                break;
            }
            case 2: {
                rectangle.setY(rectangle2.y + rectangle2.height - rectangle.height);
                break;
            }
            case 3: {
                rectangle.setX(rectangle2.x);
                break;
            }
            case 4: {
                double d = rectangle2.x + rectangle2.width / 2.0;
                rectangle.setX(d - rectangle.width / 2.0);
                break;
            }
            case 5: {
                rectangle.setX(rectangle2.x + rectangle2.width - rectangle.width);
                break;
            }
            case 6: {
                this.sectionWidget.snapToGrid(rectangle);
            }
        }
    }

    public void size(int n, Field field) {
        jimm.datavision.field.Rectangle rectangle = this.getField().getBounds();
        jimm.datavision.field.Rectangle rectangle2 = field.getBounds();
        switch (n) {
            case 0: {
                rectangle.setWidth(rectangle2.width);
                break;
            }
            case 1: {
                rectangle.setHeight(rectangle2.height);
                break;
            }
            case 2: {
                rectangle.setWidth(rectangle2.width);
                rectangle.setHeight(rectangle2.height);
            }
        }
    }

    void select(boolean bl) {
        this.sectionWidget.select(this, !this.selected, bl);
    }

    void doSelect(boolean bl) {
        JTextPane jTextPane = (JTextPane)this.getComponent();
        jTextPane.setCaretPosition(0);
        jTextPane.moveCaretPosition(0);
        if (this.selected != bl) {
            this.selected = bl;
            jTextPane.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.sectionWidget.designer.isPlacingNewTextField()) {
            this.sectionWidget.createNewTextField(mouseEvent);
        } else if (!this.mouseChangedSelectedState) {
            this.select(!mouseEvent.isShiftDown());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.action == 0 || this.action == 6) {
            return;
        }
        if (!this.selected) {
            this.select(!mouseEvent.isShiftDown());
            this.mouseChangedSelectedState = true;
        }
        Point point = mouseEvent.getPoint();
        Point point2 = this.getComponent().getLocationOnScreen();
        point.translate(point2.x, point2.y);
        if (!this.actionStartedYet) {
            this.actionStartedYet = true;
            switch (this.action) {
                case 1: {
                    this.sectionWidget.pickUp(point);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.sectionWidget.startStretching(point);
                }
            }
        }
        this.sectionWidget.dragSelectedWidgets(this.action, point);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.selected && !this.sectionWidget.designer.isPlacingNewTextField()) {
            this.cursorForPosition(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.selected && !this.sectionWidget.designer.isPlacingNewTextField()) {
            this.resetCursor();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.selected && !this.sectionWidget.designer.isPlacingNewTextField()) {
            this.cursorForPosition(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseChangedSelectedState = false;
        if (this.mousePressReleaseCommon(mouseEvent)) {
            return;
        }
        this.cursorForPosition(mouseEvent);
        this.action = this.actionFromPosition(mouseEvent);
        this.actionStartedYet = false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mousePressReleaseCommon(mouseEvent)) {
            return;
        }
        switch (this.action) {
            case 1: {
                if (!this.actionStartedYet) break;
                Point point = mouseEvent.getPoint();
                Point point2 = this.getComponent().getLocationOnScreen();
                point.translate(point2.x, point2.y);
                this.sectionWidget.putDown(this, this.preMoveInfo.screenPos, point);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!this.actionStartedYet) break;
                this.sectionWidget.stopStretching(this, this.preStretchInfo.origBounds);
            }
        }
        this.action = 0;
    }

    protected boolean mousePressReleaseCommon(MouseEvent mouseEvent) {
        if (this.sectionWidget.designer.isPlacingNewTextField()) {
            this.sectionWidget.createNewTextField(mouseEvent);
            return true;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
            return true;
        }
        return false;
    }

    public PreMoveInfo getPreMoveInfo() {
        return this.preMoveInfo;
    }

    public void pickUp(Point point) {
        this.preMoveInfo = new PreMoveInfo(this, point);
        this.sectionWidget.removeField(this);
    }

    public void putDown(SectionWidget sectionWidget) {
        jimm.datavision.field.Rectangle rectangle = this.getField().getBounds();
        rectangle.setBounds(rectangle.x - 125.0, rectangle.y - (double)sectionWidget.getBounds().y, rectangle.width, rectangle.height);
        this.moveToSection(sectionWidget);
        this.preMoveInfo = null;
    }

    void snapBack() {
        this.getField().getBounds().setBounds(this.preMoveInfo.origBounds);
        this.moveToSection(this.preMoveInfo.sectionWidget);
    }

    public void startStretching(Point point) {
        this.preStretchInfo = new PreStretchInfo(this, point);
    }

    public void stopStretching() {
        this.preStretchInfo = null;
    }

    protected void showPopupMenu(MouseEvent mouseEvent) {
        this.showOrHide.setText(this.getField().isVisible() ? I18N.get("menu", "FieldWidget.popup_hide") : I18N.get("menu", "FieldWidget.popup_show"));
        this.enableMenuItems();
        this.action = 6;
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    protected void enableMenuItems() {
        boolean bl = this.usesFormat() || this.sectionWidget.designer.someSelectedFieldUsesFormat();
        this.formatMenuItem.setEnabled(bl);
        int n = this.sectionWidget.designer.countSelectedFields();
        if (n >= 2) {
            for (int i = 0; i < this.alignSubmenu.getItemCount(); ++i) {
                this.alignSubmenu.getItem(i).setEnabled(true);
            }
            this.sizeSubmenu.setEnabled(true);
            this.aggregatesMenuItem.setEnabled(false);
        } else {
            for (int i = 0; i < this.alignSubmenu.getItemCount() - 1; ++i) {
                this.alignSubmenu.getItem(i).setEnabled(false);
            }
            this.sizeSubmenu.setEnabled(false);
            this.aggregatesMenuItem.setEnabled(this.getField().canBeAggregated());
        }
    }

    protected int actionFromPosition(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n <= 4) {
            return 2;
        }
        if ((double)n >= this.getField().getBounds().width - 4.0) {
            return 3;
        }
        if (n2 <= 4) {
            return 4;
        }
        if ((double)n2 >= this.getField().getBounds().height - 4.0) {
            return 5;
        }
        return 1;
    }

    protected void cursorForPosition(MouseEvent mouseEvent) {
        if (!this.selected) {
            this.resetCursor();
            return;
        }
        switch (this.action == 0 ? this.actionFromPosition(mouseEvent) : this.action) {
            case 1: {
                this.getComponent().setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 2: {
                this.getComponent().setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 3: {
                this.getComponent().setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 4: {
                this.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 5: {
                this.getComponent().setCursor(Cursor.getPredefinedCursor(9));
            }
        }
    }

    protected void resetCursor() {
        this.getComponent().setCursor(null);
    }

    void doDrag(int n, Point point) {
        Rectangle rectangle;
        jimm.datavision.field.Rectangle rectangle2 = this.getField().getBounds();
        if (n == 1) {
            int n2 = point.x - this.preMoveInfo.startMouseScreenPos.x;
            int n3 = point.y - this.preMoveInfo.startMouseScreenPos.y;
            rectangle2.setBounds(this.preMoveInfo.origBounds.x + (double)n2 + 125.0, this.preMoveInfo.origBounds.y + (double)n3 + (double)this.sectionWidget.getBounds().y, this.preMoveInfo.origBounds.width, this.preMoveInfo.origBounds.height);
            return;
        }
        int n4 = point.x - this.preStretchInfo.startMouseScreenPos.x;
        int n5 = point.y - this.preStretchInfo.startMouseScreenPos.y;
        switch (n) {
            case 2: {
                rectangle = new Rectangle((int)this.preStretchInfo.origBounds.x + n4, (int)this.preStretchInfo.origBounds.y, (int)this.preStretchInfo.origBounds.width - n4, (int)this.preStretchInfo.origBounds.height);
                break;
            }
            case 3: {
                rectangle = new Rectangle((int)this.preStretchInfo.origBounds.x, (int)this.preStretchInfo.origBounds.y, (int)this.preStretchInfo.origBounds.width + n4, (int)this.preStretchInfo.origBounds.height);
                break;
            }
            case 4: {
                rectangle = new Rectangle((int)this.preStretchInfo.origBounds.x, (int)this.preStretchInfo.origBounds.y + n5, (int)this.preStretchInfo.origBounds.width, (int)this.preStretchInfo.origBounds.height - n5);
                break;
            }
            case 5: {
                rectangle = new Rectangle((int)this.preStretchInfo.origBounds.x, (int)this.preStretchInfo.origBounds.y, (int)this.preStretchInfo.origBounds.width, (int)this.preStretchInfo.origBounds.height + n5);
                break;
            }
            default: {
                return;
            }
        }
        rectangle = rectangle.intersection(this.preStretchInfo.sectionBounds);
        switch (n) {
            case 2: {
                if (rectangle.width >= 2) break;
                n4 = 2 - rectangle.width;
                rectangle.x -= n4;
                rectangle.width = 2;
                break;
            }
            case 3: {
                if (rectangle.width >= 2) break;
                rectangle.width = 2;
                break;
            }
            case 4: {
                if (rectangle.height >= 2) break;
                n5 = 2 - rectangle.height;
                rectangle.y -= n5;
                rectangle.height = 2;
                break;
            }
            case 5: {
                if (rectangle.height >= 2) break;
                rectangle.height = 2;
                break;
            }
            default: {
                return;
            }
        }
        rectangle2.setBounds(rectangle);
    }

    protected void delete() {
        this.sectionWidget.designer.deleteSelectedFieldsAnd(this);
    }

    public void doDelete() {
        this.getField().getSection().removeField(this.getField());
        this.getComponent().getParent().remove(this.getComponent());
    }

    public void moveToSection(SectionWidget sectionWidget) {
        Section section = sectionWidget.section;
        Section section2 = this.getField().getSection();
        if (section != section2) {
            if (section2 != null) {
                section2.removeField(this.getField());
            }
            section.addField(this.getField());
        }
        sectionWidget.addField(this);
        this.getComponent().repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        ((DropTargetListener)((Object)this.getComponent().getParent())).drop(dropTargetDropEvent);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        Designer designer = this.sectionWidget.designer;
        if ("hide".equals(string) || "show".equals(string)) {
            this.toggleVisibility();
        } else if ("delete".equals(string)) {
            this.delete();
        } else if ("align_top".equals(string)) {
            designer.align(0);
        } else if ("align_middle".equals(string)) {
            designer.align(1);
        } else if ("align_bottom".equals(string)) {
            designer.align(2);
        } else if ("align_left".equals(string)) {
            designer.align(3);
        } else if ("align_center".equals(string)) {
            designer.align(4);
        } else if ("align_right".equals(string)) {
            designer.align(5);
        } else if ("snap_to_grid".equals(string)) {
            if (designer.countSelectedFields() > 0) {
                designer.align(6);
            } else {
                this.align(6, this.getField());
            }
        } else if ("size_width".equals(string)) {
            designer.size(0);
        } else if ("size_height".equals(string)) {
            designer.size(1);
        } else if ("size_size".equals(string)) {
            designer.size(2);
        } else if ("format".equals(string)) {
            new FormatWin(designer, this.getField(), 0);
        } else if ("border".equals(string)) {
            new FormatWin(designer, this.getField(), 1);
        } else if ("bounds".equals(string)) {
            new BoundsWin(designer, this.getField());
        } else if ("aggregates".equals(string)) {
            new AggregatesWin(designer, this);
        }
    }

    public String toString() {
        return this.getField().designLabel();
    }

    void toggleVisibility() {
        boolean bl = !this.getField().isVisible();
        this.sectionWidget.setFieldVisibility(bl, this);
    }

    public void doSetVisibility(boolean bl) {
        this.getField().setVisible(bl);
        this.setVisibilityLook();
    }

    protected void setVisibilityLook() {
        this.swingField.format();
    }

    Color getColor() {
        return this.swingField.getColor();
    }

    public Field getField() {
        return this.swingField.getField();
    }

    public JComponent getComponent() {
        return this.swingField.getComponent();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n;
        if (!(this.sectionWidget.designer.ignoreKeys || (n = keyEvent.getKeyCode()) != 8 && n != 127)) {
            this.sectionWidget.designer.deleteSelectedFields();
        }
    }
}

