/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jimm.datavision.FieldWalker;
import jimm.datavision.Formula;
import jimm.datavision.Nameable;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.UserColumn;
import jimm.datavision.field.ColumnField;
import jimm.datavision.field.Field;
import jimm.datavision.field.SpecialField;
import jimm.datavision.gui.AskStringDialog;
import jimm.datavision.gui.ColumnInfo;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FPLeafInfo;
import jimm.datavision.gui.FPTableInfo;
import jimm.datavision.gui.FieldPickerTree;
import jimm.datavision.gui.FormulaInfo;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.ParameterInfo;
import jimm.datavision.gui.SpecialInfo;
import jimm.datavision.gui.UserColumnInfo;
import jimm.datavision.gui.cmd.FPCutCommand;
import jimm.datavision.gui.cmd.FPDeleteCommand;
import jimm.datavision.gui.cmd.NameableRenameCommand;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Table;
import jimm.util.I18N;

class FieldPickerWin
extends JDialog
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
Observer {
    public static final int REPORT_DATABASE_FIELDS = 0;
    public static final int FORMULAS = 1;
    public static final int PARAMETERS = 2;
    public static final int USERCOLS = 3;
    public static final int SPECIAL_FIELDS = 4;
    public static final int ALL_DATABASE_FIELDS = 5;
    protected Report report;
    protected Designer designer;
    protected JMenuItem cutItem;
    protected JMenuItem editFormulaItem;
    protected JMenuItem renameFormulaItem;
    protected JMenuItem editParameterItem;
    protected JMenuItem renameParameterItem;
    protected JMenuItem editUserColumnItem;
    protected JMenuItem renameUserColumnItem;
    protected JMenuItem deleteItem;
    protected FieldPickerTree tree;
    protected DefaultTreeModel treeModel;
    protected DefaultMutableTreeNode formulaCategoryNode;
    protected DefaultMutableTreeNode parameterCategoryNode;
    protected DefaultMutableTreeNode userColumnCategoryNode;
    protected DefaultMutableTreeNode selectedNode;
    protected FPLeafInfo selectedInfo;
    protected Comparator nameComparator;

    FieldPickerWin(Designer designer, Report report, int n) {
        super(designer.getFrame(), I18N.get("FieldPickerWin.title"));
        this.report = report;
        this.designer = designer;
        this.nameComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((Nameable)object).getName();
                String string2 = ((Nameable)object2).getName();
                return string.compareTo(string2);
            }
        };
        this.buildWindow(n);
        this.pack();
        this.show();
    }

    public void update(Observable observable, Object object) {
        this.tree.repaint();
    }

    protected void buildWindow(int n) {
        this.buildMenuBar();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.createNodes(defaultMutableTreeNode);
        this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree = new FieldPickerTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.expandRow(n);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    protected void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildEditMenu());
        jMenuBar.add(this.buildFieldMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = MenuUtils.readMenu("FieldPickerWin.menu_file");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_file_close");
        return jMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = MenuUtils.readMenu("FieldPickerWin.menu_edit");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_edit_undo");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_edit_redo");
        jMenu.addSeparator();
        this.cutItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_edit_cut");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_edit_copy");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_edit_paste");
        this.deleteItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_edit_delete");
        return jMenu;
    }

    protected JMenu buildFieldMenu() {
        JMenu jMenu = MenuUtils.readMenu("FieldPickerWin.menu_field");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_new_formula");
        this.editFormulaItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_edit_formula");
        this.renameFormulaItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_rename_formula");
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_new_param");
        this.editParameterItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_edit_param");
        this.renameParameterItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_rename_param");
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_new_usercol");
        this.editUserColumnItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_edit_usercol");
        this.renameUserColumnItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "FieldPickerWin.menu_field_rename_usercol");
        return jMenu;
    }

    protected void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.createUsedDatabaseTables(defaultMutableTreeNode);
        this.createFormulas(defaultMutableTreeNode);
        this.createParameters(defaultMutableTreeNode);
        this.createUserColumns(defaultMutableTreeNode);
        this.createSpecialFields(defaultMutableTreeNode);
        this.createAllDatabaseTables(defaultMutableTreeNode);
    }

    protected void createUsedDatabaseTables(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(I18N.get("FieldPickerWin.db_fields"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        final TreeSet treeSet = new TreeSet(this.nameComparator);
        final TreeSet treeSet2 = new TreeSet(this.nameComparator);
        this.report.withFieldsDo(new FieldWalker(){

            public void step(Field field) {
                if (field instanceof ColumnField) {
                    Column column = ((ColumnField)field).getColumn();
                    Table table = column.getTable();
                    if (table == null) {
                        treeSet2.add(column);
                    } else {
                        treeSet.add(table);
                    }
                }
            }
        });
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.addTableNode(defaultMutableTreeNode2, (Table)iterator.next());
        }
        iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            ColumnInfo columnInfo = new ColumnInfo(column, this.designer);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(columnInfo, false));
        }
    }

    protected void createFormulas(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.formulaCategoryNode = new DefaultMutableTreeNode(I18N.get("FieldPickerWin.formulas"));
        defaultMutableTreeNode.add(this.formulaCategoryNode);
        TreeSet treeSet = new TreeSet(this.nameComparator);
        Iterator iterator = this.report.formulas();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Formula formula = (Formula)iterator.next();
            FormulaInfo formulaInfo = new FormulaInfo(this.report, formula, this.designer);
            this.formulaCategoryNode.add(new DefaultMutableTreeNode(formulaInfo));
            formula.addObserver(this);
        }
    }

    protected void createParameters(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.parameterCategoryNode = new DefaultMutableTreeNode(I18N.get("FieldPickerWin.parameters"));
        defaultMutableTreeNode.add(this.parameterCategoryNode);
        TreeSet treeSet = new TreeSet(this.nameComparator);
        Iterator iterator = this.report.parameters();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            ParameterInfo parameterInfo = new ParameterInfo(this.report, parameter, this.designer);
            this.parameterCategoryNode.add(new DefaultMutableTreeNode(parameterInfo));
            parameter.addObserver(this);
        }
    }

    protected void createUserColumns(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.userColumnCategoryNode = new DefaultMutableTreeNode(I18N.get("FieldPickerWin.usercols"));
        defaultMutableTreeNode.add(this.userColumnCategoryNode);
        TreeSet treeSet = new TreeSet(this.nameComparator);
        Iterator iterator = this.report.userColumns();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            UserColumn userColumn = (UserColumn)iterator.next();
            UserColumnInfo userColumnInfo = new UserColumnInfo(this.report, userColumn, this.designer);
            this.userColumnCategoryNode.add(new DefaultMutableTreeNode(userColumnInfo));
            userColumn.addObserver(this);
        }
    }

    protected void createSpecialFields(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(I18N.get("FieldPickerWin.specials"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        HashMap hashMap = SpecialField.specialFieldNames();
        TreeSet treeSet = new TreeSet(hashMap.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            string = "special:" + string;
            SpecialInfo specialInfo = new SpecialInfo(string2, string, this.designer);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(specialInfo);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
    }

    protected void createAllDatabaseTables(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(I18N.get("FieldPickerWin.all"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        TreeSet treeSet = new TreeSet(this.nameComparator);
        TreeSet treeSet2 = new TreeSet(this.nameComparator);
        DataSource dataSource = this.report.getDataSource();
        Iterator iterator = dataSource.tables();
        if (iterator != null) {
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
        }
        if (treeSet.isEmpty()) {
            iterator = dataSource.columns();
            while (iterator.hasNext()) {
                treeSet2.add(iterator.next());
            }
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.addTableNode(defaultMutableTreeNode2, (Table)iterator.next());
        }
        iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            ColumnInfo columnInfo = new ColumnInfo(column, this.designer);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(columnInfo, false));
        }
    }

    protected void addTableNode(DefaultMutableTreeNode defaultMutableTreeNode, Table table) {
        FPTableInfo fPTableInfo = new FPTableInfo(table, this.designer);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fPTableInfo);
        fPTableInfo.setTableNode(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(""));
    }

    protected boolean rename(Nameable nameable, String string, String string2, String string3, String string4) {
        String string5 = nameable.getName();
        String string6 = string5 == null || string5.length() == 0 ? I18N.get(string) : I18N.get(string2);
        String string7 = new AskStringDialog((Frame)((JFrame)this.getOwner()), string6, I18N.get(string3), string5).getString();
        if (string7 == null) {
            return false;
        }
        if (string7.length() == 0) {
            string7 = I18N.get(string4);
        }
        this.designer.performCommand(new NameableRenameCommand(nameable, string5, string7));
        return true;
    }

    protected void addEditableToTree(FPLeafInfo fPLeafInfo, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fPLeafInfo);
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.tree.scrollPathToVisible(treePath);
        this.tree.setSelectionPath(treePath);
        this.editSelection();
    }

    protected void newFormula() {
        Formula formula = new Formula(null, this.report, "", "");
        if (!this.renameFormula(formula)) {
            return;
        }
        this.report.addFormula(formula);
        this.addEditableToTree(new FormulaInfo(this.report, formula, this.designer), this.formulaCategoryNode);
    }

    protected boolean renameFormula() {
        return this.renameFormula((Formula)this.selectedInfo.getLeaf());
    }

    protected boolean renameFormula(Formula formula) {
        return this.rename(formula, "FieldPickerWin.new_formula_name_title", "FieldPickerWin.edit_formula_name_title", "FieldPickerWin.formula_name_prompt", "FieldPickerWin.unnamed_formula");
    }

    protected void editSelection() {
        this.selectedInfo.openEditor();
    }

    protected void newParameter() {
        Parameter parameter = new Parameter(null, this.report);
        if (!this.renameParameter(parameter)) {
            return;
        }
        this.report.addParameter(parameter);
        this.addEditableToTree(new ParameterInfo(this.report, parameter, this.designer), this.parameterCategoryNode);
    }

    protected boolean renameParameter() {
        return this.renameParameter((Parameter)this.selectedInfo.getLeaf());
    }

    protected boolean renameParameter(Parameter parameter) {
        return this.rename(parameter, "FieldPickerWin.new_param_name_title", "FieldPickerWin.edit_param_name_title", "FieldPickerWin.param_name_prompt", "FieldPickerWin.unnamed_parameter");
    }

    protected void newUserColumn() {
        UserColumn userColumn = new UserColumn(null, this.report, "");
        if (!this.renameUserColumn(userColumn)) {
            return;
        }
        this.report.addUserColumn(userColumn);
        this.addEditableToTree(new UserColumnInfo(this.report, userColumn, this.designer), this.userColumnCategoryNode);
    }

    protected boolean renameUserColumn() {
        return this.renameUserColumn((UserColumn)this.selectedInfo.getLeaf());
    }

    protected boolean renameUserColumn(UserColumn userColumn) {
        return this.rename(userColumn, "FieldPickerWin.new_usercol_name_title", "FieldPickerWin.edit_usercol_name_title", "FieldPickerWin.usercol_name_prompt", "FieldPickerWin.unnamed_usercol");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("close".equals(string)) {
            this.dispose();
        } else if ("cut".equals(string)) {
            this.designer.performCommand(new FPCutCommand(this.report, this.designer, this.tree, this.selectedNode));
        } else if ("new_formula".equals(string)) {
            this.newFormula();
        } else if ("edit_formula".equals(string)) {
            this.editSelection();
        } else if ("rename_formula".equals(string)) {
            this.renameFormula();
        } else if ("new_parameter".equals(string)) {
            this.newParameter();
        } else if ("edit_parameter".equals(string)) {
            this.editSelection();
        } else if ("rename_parameter".equals(string)) {
            this.renameParameter();
        } else if ("new_user_column".equals(string)) {
            this.newUserColumn();
        } else if ("edit_user_column".equals(string)) {
            this.editSelection();
        } else if ("rename_user_column".equals(string)) {
            this.renameUserColumn();
        } else if ("delete".equals(string)) {
            this.designer.performCommand(new FPDeleteCommand(this.report, this.designer, this.tree, this.selectedNode));
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.isAddedPath()) {
            this.selectedNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            Object object = this.selectedNode.getUserObject();
            this.selectedInfo = object instanceof FPLeafInfo ? (FPLeafInfo)object : null;
            if (this.selectedInfo == null) {
                this.cutItem.setEnabled(false);
                this.editFormulaItem.setEnabled(false);
                this.editParameterItem.setEnabled(false);
                this.editUserColumnItem.setEnabled(false);
                this.renameFormulaItem.setEnabled(false);
                this.renameParameterItem.setEnabled(false);
                this.renameUserColumnItem.setEnabled(false);
                this.deleteItem.setEnabled(false);
            } else {
                boolean bl = this.selectedInfo instanceof FormulaInfo;
                boolean bl2 = this.selectedInfo instanceof ParameterInfo;
                boolean bl3 = this.selectedInfo instanceof UserColumnInfo;
                this.cutItem.setEnabled(this.selectedInfo.isDeletable());
                this.deleteItem.setEnabled(this.selectedInfo.isDeletable());
                this.editFormulaItem.setEnabled(bl);
                this.editParameterItem.setEnabled(bl2);
                this.editUserColumnItem.setEnabled(bl3);
                this.renameFormulaItem.setEnabled(bl);
                this.renameParameterItem.setEnabled(bl2);
                this.renameUserColumnItem.setEnabled(bl3);
            }
        } else {
            this.selectedInfo = null;
            this.cutItem.setEnabled(false);
            this.editFormulaItem.setEnabled(false);
            this.editParameterItem.setEnabled(false);
            this.editUserColumnItem.setEnabled(false);
            this.renameFormulaItem.setEnabled(false);
            this.renameParameterItem.setEnabled(false);
            this.renameUserColumnItem.setEnabled(false);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FPTableInfo) {
            ((FPTableInfo)object).loadColumns();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }
}

