/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jimm.datavision.gui.FPLeafInfo;

public class FieldPickerTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    public FieldPickerTree(DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = FieldPickerTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && mouseEvent.getClickCount() == 2) {
                    FieldPickerTree.this.doubleClicked(treePath);
                }
                super.mousePressed(mouseEvent);
            }
        });
    }

    protected void doubleClicked(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FPLeafInfo) {
            ((FPLeafInfo)object).openEditor();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        FPLeafInfo fPLeafInfo;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FPLeafInfo && (fPLeafInfo = (FPLeafInfo)object) != null) {
            dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, new StringSelection(fPLeafInfo.dragString()), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(defaultMutableTreeNode);
        }
    }
}

