/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.layout.CharSepLE;
import jimm.datavision.layout.DocBookLE;
import jimm.datavision.layout.HTMLLE;
import jimm.datavision.layout.LaTeXLE;
import jimm.datavision.layout.LayoutEngine;
import jimm.datavision.layout.XMLLE;
import jimm.datavision.layout.pdf.PDFLE;
import jimm.util.I18N;
import jimm.util.XMLWriter;

public class ExportWin
extends JDialog
implements ActionListener {
    protected static Preferences prefs = Preferences.userNodeForPackage(class$jimm$datavision$gui$ExportWin == null ? (class$jimm$datavision$gui$ExportWin = ExportWin.class$("jimm.datavision.gui.ExportWin")) : class$jimm$datavision$gui$ExportWin);
    protected Report report;
    protected JComboBox combo;
    static /* synthetic */ Class class$jimm$datavision$gui$ExportWin;

    public ExportWin(Frame frame, Report report) {
        super(frame, I18N.get("ExportWin.title"));
        this.report = report;
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        this.combo = new JComboBox<String>(this.layoutNames());
        String string = prefs.get("last_used_engine", null);
        if (string != null) {
            this.combo.setSelectedItem(string);
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.add(this.combo);
        JPanel jPanel2 = this.buildButtonPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("GUI.ok"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        jButton = new JButton(I18N.get("GUI.cancel"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("GUI.ok").equals(string)) {
            String string2 = (String)this.combo.getSelectedItem();
            prefs.put("last_used_engine", string2);
            this.dispose();
            this.runReport(string2);
        } else if (I18N.get("GUI.cancel").equals(string)) {
            this.dispose();
        }
    }

    protected String[] layoutNames() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = I18N.get("ExportWin.le_comma");
        stringArray[n++] = I18N.get("ExportWin.le_tab");
        stringArray[n++] = I18N.get("ExportWin.le_docbook");
        stringArray[n++] = I18N.get("ExportWin.le_html");
        stringArray[n++] = I18N.get("ExportWin.le_latex");
        stringArray[n++] = I18N.get("ExportWin.le_pdf");
        stringArray[n++] = I18N.get("ExportWin.le_xml");
        return stringArray;
    }

    protected void runReport(String string) {
        String string2 = null;
        if (I18N.get("ExportWin.le_comma").equals(string)) {
            string2 = ".csv";
        } else if (I18N.get("ExportWin.le_tab").equals(string)) {
            string2 = ".tab";
        } else if (I18N.get("ExportWin.le_docbook").equals(string)) {
            string2 = ".sgml";
        } else if (I18N.get("ExportWin.le_html").equals(string)) {
            string2 = ".html";
        } else if (I18N.get("ExportWin.le_latex").equals(string)) {
            string2 = ".tex";
        } else if (I18N.get("ExportWin.le_pdf").equals(string)) {
            string2 = ".pdf";
        } else if (I18N.get("ExportWin.le_xml").equals(string)) {
            string2 = ".xml";
        }
        String string3 = this.selectFile(string2);
        if (string3 == null) {
            return;
        }
        try {
            LayoutEngine layoutEngine = null;
            if (I18N.get("ExportWin.le_comma").equals(string)) {
                layoutEngine = new CharSepLE(new PrintWriter(new FileWriter(string3)), ',');
            } else if (I18N.get("ExportWin.le_tab").equals(string)) {
                layoutEngine = new CharSepLE(new PrintWriter(new FileWriter(string3)), '\t');
            } else if (I18N.get("ExportWin.le_docbook").equals(string)) {
                layoutEngine = new DocBookLE(new PrintWriter(new FileWriter(string3)));
            } else if (I18N.get("ExportWin.le_html").equals(string)) {
                layoutEngine = new HTMLLE(new PrintWriter(new FileWriter(string3)));
            } else if (I18N.get("ExportWin.le_latex").equals(string)) {
                layoutEngine = new LaTeXLE(new PrintWriter(new FileWriter(string3)));
            } else if (I18N.get("ExportWin.le_pdf").equals(string)) {
                layoutEngine = new PDFLE(new FileOutputStream(string3));
            } else if (I18N.get("ExportWin.le_xml").equals(string)) {
                layoutEngine = new XMLLE(new XMLWriter(new FileOutputStream(string3)));
            }
            if (layoutEngine != null) {
                this.report.setLayoutEngine(layoutEngine);
                this.report.run();
            }
        }
        catch (IOException iOException) {
            ErrorHandler.error(I18N.get("ExportWin.err_msg"), iOException, I18N.get("ExportWin.err_title"));
        }
    }

    protected String selectFile(String string) {
        JFileChooser jFileChooser = Designer.getChooser();
        if (jFileChooser.showSaveDialog(this.getOwner()) == 0) {
            return jFileChooser.getSelectedFile().getPath();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

