/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import jimm.datavision.field.Field;
import jimm.datavision.gui.AskStringDialog;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.cmd.WidgetRenameCommand;

public abstract class EditWinWidget
extends FieldWidget {
    protected JDialog editor;

    EditWinWidget(SectionWidget sectionWidget, Field field) {
        super(sectionWidget, field);
    }

    protected void addCustomPopupItems() {
        MenuUtils.addToMenu((ActionListener)this, this.popup, "EditWinWidget.popup_edit", POPUP_FONT);
        MenuUtils.addToMenu((ActionListener)this, this.popup, "EditWinWidget.popup_rename", POPUP_FONT);
        this.popup.addSeparator();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if ("edit".equals(string)) {
            this.openEditor();
        } else if ("rename".equals(string)) {
            this.rename();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.sectionWidget.designer.isPlacingNewTextField()) {
            this.sectionWidget.createNewTextField(mouseEvent);
        }
        if (mouseEvent.getClickCount() == 2) {
            this.openEditor();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    public void openEditor() {
        if (this.editor == null) {
            this.editor = this.createEditor();
        } else {
            this.updateEditor();
        }
        this.editor.setVisible(true);
        this.editor.toFront();
    }

    protected abstract JDialog createEditor();

    protected void updateEditor() {
    }

    protected void rename() {
        Designer designer = this.sectionWidget.designer;
        String string = new AskStringDialog(designer.getFrame(), this.getEditorTitle(), this.getEditorLabel(), this.getWidgetName()).getString();
        if (string != null) {
            designer.performCommand(new WidgetRenameCommand(this, this.getWidgetName(), string));
        }
    }

    protected abstract String getWidgetName();

    protected abstract String getEditorTitle();

    protected abstract String getEditorLabel();

    public abstract void setWidgetName(String var1);
}

