/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.cmd.CompoundCommand;
import jimm.util.I18N;

public abstract class EditWin
extends JDialog
implements ActionListener {
    protected Designer designer;
    protected JButton revertButton;
    protected CompoundCommand commands;

    public EditWin(Designer designer, String string, String string2) {
        this(designer, string, string2, false);
    }

    public EditWin(Designer designer, String string, String string2, boolean bl) {
        super(designer.getFrame(), string, bl);
        this.designer = designer;
        this.commands = new CompoundCommand(I18N.get(string2));
    }

    protected JPanel closeButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("GUI.ok"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        jButton = new JButton(I18N.get("GUI.apply"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        this.revertButton = new JButton(I18N.get("GUI.revert"));
        jPanel.add(this.revertButton);
        this.revertButton.addActionListener(this);
        this.revertButton.setEnabled(false);
        jButton = new JButton(I18N.get("GUI.cancel"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (I18N.get("GUI.ok").equals(string)) {
            this.save(true);
            this.dispose();
        } else if (I18N.get("GUI.apply").equals(string)) {
            this.save(false);
        } else if (I18N.get("GUI.revert").equals(string)) {
            this.revert();
        } else if (I18N.get("GUI.cancel").equals(string)) {
            this.revert();
            this.dispose();
        }
    }

    protected void save(boolean bl) {
        this.doSave();
        this.revertButton.setEnabled(true);
        if (bl && this.commands.numCommands() > 0) {
            this.designer.addCommand(this.commands);
        }
    }

    protected abstract void doSave();

    protected void revert() {
        this.commands.undo();
        this.commands = new CompoundCommand(this.commands.getName());
        this.doRevert();
    }

    protected abstract void doRevert();
}

