/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class EditFieldLayout {
    protected ArrayList rows = new ArrayList();
    protected Border border;
    protected JPanel panel;

    public Component add(String string, Component component) {
        if (string == null || string.length() == 0) {
            string = "";
        } else if (!string.endsWith(":")) {
            string = string + ":";
        }
        this.rows.add(new Row(new JLabel(string), component));
        return component;
    }

    public JTextField addTextField(String string) {
        return (JTextField)this.add(string, new JTextField());
    }

    public JTextField addTextField(String string, int n) {
        return (JTextField)this.add(string, new JTextField(n));
    }

    public JTextField addTextField(String string, String string2) {
        return (JTextField)this.add(string, new JTextField(string2 == null ? "" : string2));
    }

    public JTextField addTextField(String string, String string2, int n) {
        return (JTextField)this.add(string, new JTextField(string2 == null ? "" : string2, n));
    }

    public JTextArea addTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(string, jTextArea);
        return jTextArea;
    }

    public JTextArea addTextArea(String string, int n, int n2) {
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(string, jTextArea);
        return jTextArea;
    }

    public JTextArea addTextArea(String string, String string2) {
        JTextArea jTextArea = new JTextArea(string2 == null ? "" : string2);
        jTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(string, jTextArea);
        return jTextArea;
    }

    public JTextArea addTextArea(String string, String string2, int n, int n2) {
        JTextArea jTextArea = new JTextArea(string2 == null ? "" : string2, n, n2);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        this.add(string, jScrollPane);
        return jTextArea;
    }

    public JCheckBox addCheckBox(String string) {
        return this.addCheckBox(string, 0);
    }

    public JCheckBox addCheckBox(String string, int n) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setMnemonic(n);
        return (JCheckBox)this.add(null, jCheckBox);
    }

    public JComboBox addComboBox(String string, Object[] objectArray) {
        return this.addComboBox(string, objectArray, false);
    }

    public JComboBox addComboBox(String string, Object[] objectArray, boolean bl) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(bl);
        return (JComboBox)this.add(string, jComboBox);
    }

    public JLabel addLabel(String string, String string2) {
        return (JLabel)this.add(string, new JLabel(string2 == null ? "" : string2));
    }

    public JPasswordField addPasswordField(String string) {
        return (JPasswordField)this.add(string, new JPasswordField());
    }

    public JPasswordField addPasswordField(String string, int n) {
        return (JPasswordField)this.add(string, new JPasswordField(n));
    }

    public JPasswordField addPasswordField(String string, String string2) {
        return (JPasswordField)this.add(string, new JPasswordField(string2 == null ? "" : string2));
    }

    public JPasswordField addPasswordField(String string, String string2, int n) {
        return (JPasswordField)this.add(string, new JPasswordField(string2 == null ? "" : string2, n));
    }

    public JButton addButton(String string) {
        return (JButton)this.add(null, new JButton(string));
    }

    public void skipRow() {
        this.rows.add(null);
    }

    public void setBorder(int n) {
        this.setBorder(n, n, n, n);
    }

    public void setBorder(int n, int n2, int n3, int n4) {
        this.border = BorderFactory.createEmptyBorder(n, n2, n3, n4);
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.buildPanel();
        }
        return this.panel;
    }

    protected void buildPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panel = new JPanel();
        this.panel.setLayout(gridBagLayout);
        if (this.border != null) {
            this.panel.setBorder(this.border);
        }
        gridBagConstraints.gridy = 0;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row != null) {
                if (row.label != null) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.anchor = 12;
                    gridBagLayout.setConstraints(row.label, gridBagConstraints);
                    this.panel.add(row.label);
                }
                if (row.component != null) {
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 18;
                    gridBagLayout.setConstraints(row.component, gridBagConstraints);
                    this.panel.add(row.component);
                }
            }
            ++gridBagConstraints.gridy;
        }
    }

    static class Row {
        protected JLabel label;
        protected Component component;

        Row(JLabel jLabel, Component component) {
            this.label = jLabel;
            this.component = component;
        }
    }
}

